/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.customchannelevents;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.customchannelevents.requests.NotifyAttributeCollectedRequest;
import com.intercom.api.resources.unstable.customchannelevents.requests.NotifyNewMessageRequest;
import com.intercom.api.resources.unstable.customchannelevents.requests.NotifyQuickReplySelectedRequest;
import com.intercom.api.resources.unstable.types.CustomChannelBaseEvent;
import com.intercom.api.resources.unstable.types.CustomChannelNotificationResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomChannelEventsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCustomChannelEventsClient rawClient;

    public AsyncCustomChannelEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomChannelEventsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCustomChannelEventsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Notifies Intercom that a new conversation was created in your custom channel/platform. This triggers conversation creation and workflow automations within Intercom for your custom channel integration.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is restricted to customers with access to the closed beta for &quot;Fin over API&quot;.</p>
     * </blockquote>
     */
    public CompletableFuture<CustomChannelNotificationResponse> notifyNewConversation(CustomChannelBaseEvent request) {
        return this.rawClient.notifyNewConversation(request).thenApply(response -> response.body());
    }

    /**
     * Notifies Intercom that a new conversation was created in your custom channel/platform. This triggers conversation creation and workflow automations within Intercom for your custom channel integration.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is restricted to customers with access to the closed beta for &quot;Fin over API&quot;.</p>
     * </blockquote>
     */
    public CompletableFuture<CustomChannelNotificationResponse> notifyNewConversation(
            CustomChannelBaseEvent request, RequestOptions requestOptions) {
        return this.rawClient.notifyNewConversation(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Notifies Intercom that a new message was sent in a conversation on your custom channel/platform. This allows Intercom to process the message and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is restricted to customers with access to the closed beta for &quot;Fin over API&quot;.</p>
     * </blockquote>
     */
    public CompletableFuture<CustomChannelNotificationResponse> notifyNewMessage(NotifyNewMessageRequest request) {
        return this.rawClient.notifyNewMessage(request).thenApply(response -> response.body());
    }

    /**
     * Notifies Intercom that a new message was sent in a conversation on your custom channel/platform. This allows Intercom to process the message and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is restricted to customers with access to the closed beta for &quot;Fin over API&quot;.</p>
     * </blockquote>
     */
    public CompletableFuture<CustomChannelNotificationResponse> notifyNewMessage(
            NotifyNewMessageRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyNewMessage(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Notifies Intercom that a user selected a quick reply option in your custom channel/platform. This allows Intercom to process the response and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is restricted to customers with access to the closed beta for &quot;Fin over API&quot;.</p>
     * </blockquote>
     */
    public CompletableFuture<CustomChannelNotificationResponse> notifyQuickReplySelected(
            NotifyQuickReplySelectedRequest request) {
        return this.rawClient.notifyQuickReplySelected(request).thenApply(response -> response.body());
    }

    /**
     * Notifies Intercom that a user selected a quick reply option in your custom channel/platform. This allows Intercom to process the response and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is restricted to customers with access to the closed beta for &quot;Fin over API&quot;.</p>
     * </blockquote>
     */
    public CompletableFuture<CustomChannelNotificationResponse> notifyQuickReplySelected(
            NotifyQuickReplySelectedRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyQuickReplySelected(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Notifies Intercom that a user provided a response to an attribute collector in your custom channel/platform. This allows Intercom to process the attribute and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is restricted to customers with access to the closed beta for &quot;Fin over API&quot;.</p>
     * </blockquote>
     */
    public CompletableFuture<CustomChannelNotificationResponse> notifyAttributeCollected(
            NotifyAttributeCollectedRequest request) {
        return this.rawClient.notifyAttributeCollected(request).thenApply(response -> response.body());
    }

    /**
     * Notifies Intercom that a user provided a response to an attribute collector in your custom channel/platform. This allows Intercom to process the attribute and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is restricted to customers with access to the closed beta for &quot;Fin over API&quot;.</p>
     * </blockquote>
     */
    public CompletableFuture<CustomChannelNotificationResponse> notifyAttributeCollected(
            NotifyAttributeCollectedRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyAttributeCollected(request, requestOptions).thenApply(response -> response.body());
    }
}
