/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.dataattributes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.dataattributes.requests.CreateDataAttributeRequest;
import com.intercom.api.resources.unstable.dataattributes.requests.LisDataAttributesRequest;
import com.intercom.api.resources.unstable.dataattributes.requests.UpdateDataAttributeRequest;
import com.intercom.api.resources.unstable.dataattributes.types.DataAttribute;
import com.intercom.api.resources.unstable.types.DataAttributeList;

public class DataAttributesClient {
    protected final ClientOptions clientOptions;

    private final RawDataAttributesClient rawClient;

    public DataAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDataAttributesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawDataAttributesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all data attributes belonging to a workspace for contacts, companies or conversations.
     */
    public DataAttributeList lisDataAttributes() {
        return this.rawClient.lisDataAttributes().body();
    }

    /**
     * You can fetch a list of all data attributes belonging to a workspace for contacts, companies or conversations.
     */
    public DataAttributeList lisDataAttributes(LisDataAttributesRequest request) {
        return this.rawClient.lisDataAttributes(request).body();
    }

    /**
     * You can fetch a list of all data attributes belonging to a workspace for contacts, companies or conversations.
     */
    public DataAttributeList lisDataAttributes(LisDataAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.lisDataAttributes(request, requestOptions).body();
    }

    /**
     * You can create a data attributes for a <code>contact</code> or a <code>company</code>.
     */
    public DataAttribute createDataAttribute(CreateDataAttributeRequest request) {
        return this.rawClient.createDataAttribute(request).body();
    }

    /**
     * You can create a data attributes for a <code>contact</code> or a <code>company</code>.
     */
    public DataAttribute createDataAttribute(CreateDataAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.createDataAttribute(request, requestOptions).body();
    }

    /**
     * You can update a data attribute.
     * <blockquote>
     * <p>🚧 Updating the data type is not possible</p>
     * <p>It is currently a dangerous action to execute changing a data attribute's type via the API. You will need to update the type via the UI instead.</p>
     * </blockquote>
     */
    public DataAttribute updateDataAttribute(UpdateDataAttributeRequest request) {
        return this.rawClient.updateDataAttribute(request).body();
    }

    /**
     * You can update a data attribute.
     * <blockquote>
     * <p>🚧 Updating the data type is not possible</p>
     * <p>It is currently a dangerous action to execute changing a data attribute's type via the API. You will need to update the type via the UI instead.</p>
     * </blockquote>
     */
    public DataAttribute updateDataAttribute(UpdateDataAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateDataAttribute(request, requestOptions).body();
    }
}
