/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.GroupTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Collection.Builder.class)
public final class Collection {
    private final Optional<String> id;

    private final Optional<String> workspaceId;

    private final Optional<String> name;

    private final Optional<String> description;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> url;

    private final Optional<String> icon;

    private final Optional<Integer> order;

    private final Optional<String> defaultLocale;

    private final Optional<GroupTranslatedContent> translatedContent;

    private final Optional<String> parentId;

    private final Optional<Integer> helpCenterId;

    private final Map<String, Object> additionalProperties;

    private Collection(
            Optional<String> id,
            Optional<String> workspaceId,
            Optional<String> name,
            Optional<String> description,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> url,
            Optional<String> icon,
            Optional<Integer> order,
            Optional<String> defaultLocale,
            Optional<GroupTranslatedContent> translatedContent,
            Optional<String> parentId,
            Optional<Integer> helpCenterId,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.name = name;
        this.description = description;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.icon = icon;
        this.order = order;
        this.defaultLocale = defaultLocale;
        this.translatedContent = translatedContent;
        this.parentId = parentId;
        this.helpCenterId = helpCenterId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the collection which is given by Intercom.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The id of the workspace which the collection belongs to.
     */
    @JsonProperty("workspace_id")
    public Optional<String> getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The name of the collection. For multilingual collections, this will be the name of the default language's content.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The description of the collection. For multilingual help centers, this will be the description of the collection for the default language.
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return The time when the article was created (seconds). For multilingual articles, this will be the timestamp of creation of the default language's content.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the article was last updated (seconds). For multilingual articles, this will be the timestamp of last update of the default language's content.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The URL of the collection. For multilingual help centers, this will be the URL of the collection for the default language.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return The icon of the collection.
     */
    @JsonProperty("icon")
    public Optional<String> getIcon() {
        return icon;
    }

    /**
     * @return The order of the section in relation to others sections within a collection. Values go from <code>0</code> upwards. <code>0</code> is the default if there's no order.
     */
    @JsonProperty("order")
    public Optional<Integer> getOrder() {
        return order;
    }

    /**
     * @return The default locale of the help center. This field is only returned for multilingual help centers.
     */
    @JsonProperty("default_locale")
    public Optional<String> getDefaultLocale() {
        return defaultLocale;
    }

    @JsonProperty("translated_content")
    public Optional<GroupTranslatedContent> getTranslatedContent() {
        return translatedContent;
    }

    /**
     * @return The id of the parent collection. If <code>null</code> then it is the first level collection.
     */
    @JsonProperty("parent_id")
    public Optional<String> getParentId() {
        return parentId;
    }

    /**
     * @return The id of the help center the collection is in.
     */
    @JsonProperty("help_center_id")
    public Optional<Integer> getHelpCenterId() {
        return helpCenterId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Collection && equalTo((Collection) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Collection other) {
        return id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && name.equals(other.name)
                && description.equals(other.description)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && url.equals(other.url)
                && icon.equals(other.icon)
                && order.equals(other.order)
                && defaultLocale.equals(other.defaultLocale)
                && translatedContent.equals(other.translatedContent)
                && parentId.equals(other.parentId)
                && helpCenterId.equals(other.helpCenterId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.workspaceId,
                this.name,
                this.description,
                this.createdAt,
                this.updatedAt,
                this.url,
                this.icon,
                this.order,
                this.defaultLocale,
                this.translatedContent,
                this.parentId,
                this.helpCenterId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();

        private Optional<String> workspaceId = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> url = Optional.empty();

        private Optional<String> icon = Optional.empty();

        private Optional<Integer> order = Optional.empty();

        private Optional<String> defaultLocale = Optional.empty();

        private Optional<GroupTranslatedContent> translatedContent = Optional.empty();

        private Optional<String> parentId = Optional.empty();

        private Optional<Integer> helpCenterId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Collection other) {
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            name(other.getName());
            description(other.getDescription());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            url(other.getUrl());
            icon(other.getIcon());
            order(other.getOrder());
            defaultLocale(other.getDefaultLocale());
            translatedContent(other.getTranslatedContent());
            parentId(other.getParentId());
            helpCenterId(other.getHelpCenterId());
            return this;
        }

        /**
         * <p>The unique identifier for the collection which is given by Intercom.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The id of the workspace which the collection belongs to.</p>
         */
        @JsonSetter(value = "workspace_id", nulls = Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        /**
         * <p>The name of the collection. For multilingual collections, this will be the name of the default language's content.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The description of the collection. For multilingual help centers, this will be the description of the collection for the default language.</p>
         */
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The time when the article was created (seconds). For multilingual articles, this will be the timestamp of creation of the default language's content.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time when the article was last updated (seconds). For multilingual articles, this will be the timestamp of last update of the default language's content.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The URL of the collection. For multilingual help centers, this will be the URL of the collection for the default language.</p>
         */
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>The icon of the collection.</p>
         */
        @JsonSetter(value = "icon", nulls = Nulls.SKIP)
        public Builder icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        /**
         * <p>The order of the section in relation to others sections within a collection. Values go from <code>0</code> upwards. <code>0</code> is the default if there's no order.</p>
         */
        @JsonSetter(value = "order", nulls = Nulls.SKIP)
        public Builder order(Optional<Integer> order) {
            this.order = order;
            return this;
        }

        public Builder order(Integer order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        /**
         * <p>The default locale of the help center. This field is only returned for multilingual help centers.</p>
         */
        @JsonSetter(value = "default_locale", nulls = Nulls.SKIP)
        public Builder defaultLocale(Optional<String> defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public Builder defaultLocale(String defaultLocale) {
            this.defaultLocale = Optional.ofNullable(defaultLocale);
            return this;
        }

        @JsonSetter(value = "translated_content", nulls = Nulls.SKIP)
        public Builder translatedContent(Optional<GroupTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        public Builder translatedContent(GroupTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        /**
         * <p>The id of the parent collection. If <code>null</code> then it is the first level collection.</p>
         */
        @JsonSetter(value = "parent_id", nulls = Nulls.SKIP)
        public Builder parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        /**
         * <p>The id of the help center the collection is in.</p>
         */
        @JsonSetter(value = "help_center_id", nulls = Nulls.SKIP)
        public Builder helpCenterId(Optional<Integer> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        public Builder helpCenterId(Integer helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        public Collection build() {
            return new Collection(
                    id,
                    workspaceId,
                    name,
                    description,
                    createdAt,
                    updatedAt,
                    url,
                    icon,
                    order,
                    defaultLocale,
                    translatedContent,
                    parentId,
                    helpCenterId,
                    additionalProperties);
        }
    }
}
