/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.subscriptiontypes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AttachSubscriptionTypeToContactRequest.Builder.class)
public final class AttachSubscriptionTypeToContactRequest {
    private final String contactId;

    private final String id;

    private final String consentType;

    private final Map<String, Object> additionalProperties;

    private AttachSubscriptionTypeToContactRequest(
            String contactId, String id, String consentType, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.id = id;
        this.consentType = consentType;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the contact which is given by Intercom
     */
    @JsonProperty("contact_id")
    public String getContactId() {
        return contactId;
    }

    /**
     * @return The unique identifier for the subscription which is given by Intercom
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The consent_type of a subscription, opt_out or opt_in.
     */
    @JsonProperty("consent_type")
    public String getConsentType() {
        return consentType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AttachSubscriptionTypeToContactRequest
                && equalTo((AttachSubscriptionTypeToContactRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachSubscriptionTypeToContactRequest other) {
        return contactId.equals(other.contactId) && id.equals(other.id) && consentType.equals(other.consentType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.contactId, this.id, this.consentType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    public interface ContactIdStage {
        /**
         * The unique identifier for the contact which is given by Intercom
         */
        IdStage contactId(@NotNull String contactId);

        Builder from(AttachSubscriptionTypeToContactRequest other);
    }

    public interface IdStage {
        /**
         * The unique identifier for the subscription which is given by Intercom
         */
        ConsentTypeStage id(@NotNull String id);
    }

    public interface ConsentTypeStage {
        /**
         * The consent_type of a subscription, opt_out or opt_in.
         */
        _FinalStage consentType(@NotNull String consentType);
    }

    public interface _FinalStage {
        AttachSubscriptionTypeToContactRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ContactIdStage, IdStage, ConsentTypeStage, _FinalStage {
        private String contactId;

        private String id;

        private String consentType;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AttachSubscriptionTypeToContactRequest other) {
            contactId(other.getContactId());
            id(other.getId());
            consentType(other.getConsentType());
            return this;
        }

        /**
         * The unique identifier for the contact which is given by Intercom<p>The unique identifier for the contact which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact_id")
        public IdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        /**
         * The unique identifier for the subscription which is given by Intercom<p>The unique identifier for the subscription which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public ConsentTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The consent_type of a subscription, opt_out or opt_in.<p>The consent_type of a subscription, opt_out or opt_in.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("consent_type")
        public _FinalStage consentType(@NotNull String consentType) {
            this.consentType = Objects.requireNonNull(consentType, "consentType must not be null");
            return this;
        }

        @java.lang.Override
        public AttachSubscriptionTypeToContactRequest build() {
            return new AttachSubscriptionTypeToContactRequest(contactId, id, consentType, additionalProperties);
        }
    }
}
