/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.subscriptiontypes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.Translation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SubscriptionType.Builder.class)
public final class SubscriptionType {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<State> state;

    private final Optional<Translation> defaultTranslation;

    private final Optional<List<Translation>> translations;

    private final Optional<ConsentType> consentType;

    private final Optional<List<ContentTypesItem>> contentTypes;

    private final Map<String, Object> additionalProperties;

    private SubscriptionType(
            Optional<String> type,
            Optional<String> id,
            Optional<State> state,
            Optional<Translation> defaultTranslation,
            Optional<List<Translation>> translations,
            Optional<ConsentType> consentType,
            Optional<List<ContentTypesItem>> contentTypes,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.state = state;
        this.defaultTranslation = defaultTranslation;
        this.translations = translations;
        this.consentType = consentType;
        this.contentTypes = contentTypes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object - subscription
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The unique identifier representing the subscription type.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The state of the subscription type.
     */
    @JsonProperty("state")
    public Optional<State> getState() {
        return state;
    }

    @JsonProperty("default_translation")
    public Optional<Translation> getDefaultTranslation() {
        return defaultTranslation;
    }

    /**
     * @return An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.
     */
    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return translations;
    }

    /**
     * @return Describes the type of consent.
     */
    @JsonProperty("consent_type")
    public Optional<ConsentType> getConsentType() {
        return consentType;
    }

    /**
     * @return The message types that this subscription supports - can contain <code>email</code> or <code>sms_message</code>.
     */
    @JsonProperty("content_types")
    public Optional<List<ContentTypesItem>> getContentTypes() {
        return contentTypes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SubscriptionType && equalTo((SubscriptionType) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionType other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && state.equals(other.state)
                && defaultTranslation.equals(other.defaultTranslation)
                && translations.equals(other.translations)
                && consentType.equals(other.consentType)
                && contentTypes.equals(other.contentTypes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.state,
                this.defaultTranslation,
                this.translations,
                this.consentType,
                this.contentTypes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<State> state = Optional.empty();

        private Optional<Translation> defaultTranslation = Optional.empty();

        private Optional<List<Translation>> translations = Optional.empty();

        private Optional<ConsentType> consentType = Optional.empty();

        private Optional<List<ContentTypesItem>> contentTypes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SubscriptionType other) {
            type(other.getType());
            id(other.getId());
            state(other.getState());
            defaultTranslation(other.getDefaultTranslation());
            translations(other.getTranslations());
            consentType(other.getConsentType());
            contentTypes(other.getContentTypes());
            return this;
        }

        /**
         * <p>The type of the object - subscription</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The unique identifier representing the subscription type.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The state of the subscription type.</p>
         */
        @JsonSetter(value = "state", nulls = Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value = "default_translation", nulls = Nulls.SKIP)
        public Builder defaultTranslation(Optional<Translation> defaultTranslation) {
            this.defaultTranslation = defaultTranslation;
            return this;
        }

        public Builder defaultTranslation(Translation defaultTranslation) {
            this.defaultTranslation = Optional.ofNullable(defaultTranslation);
            return this;
        }

        /**
         * <p>An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.</p>
         */
        @JsonSetter(value = "translations", nulls = Nulls.SKIP)
        public Builder translations(Optional<List<Translation>> translations) {
            this.translations = translations;
            return this;
        }

        public Builder translations(List<Translation> translations) {
            this.translations = Optional.ofNullable(translations);
            return this;
        }

        /**
         * <p>Describes the type of consent.</p>
         */
        @JsonSetter(value = "consent_type", nulls = Nulls.SKIP)
        public Builder consentType(Optional<ConsentType> consentType) {
            this.consentType = consentType;
            return this;
        }

        public Builder consentType(ConsentType consentType) {
            this.consentType = Optional.ofNullable(consentType);
            return this;
        }

        /**
         * <p>The message types that this subscription supports - can contain <code>email</code> or <code>sms_message</code>.</p>
         */
        @JsonSetter(value = "content_types", nulls = Nulls.SKIP)
        public Builder contentTypes(Optional<List<ContentTypesItem>> contentTypes) {
            this.contentTypes = contentTypes;
            return this;
        }

        public Builder contentTypes(List<ContentTypesItem> contentTypes) {
            this.contentTypes = Optional.ofNullable(contentTypes);
            return this;
        }

        public SubscriptionType build() {
            return new SubscriptionType(
                    type, id, state, defaultTranslation, translations, consentType, contentTypes, additionalProperties);
        }
    }

    public static final class ConsentType {
        public static final ConsentType OPT_IN = new ConsentType(Value.OPT_IN, "opt_in");

        public static final ConsentType OPT_OUT = new ConsentType(Value.OPT_OUT, "opt_out");

        private final Value value;

        private final String string;

        ConsentType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof ConsentType && this.string.equals(((ConsentType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case OPT_IN:
                    return visitor.visitOptIn();
                case OPT_OUT:
                    return visitor.visitOptOut();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static ConsentType valueOf(String value) {
            switch (value) {
                case "opt_in":
                    return OPT_IN;
                case "opt_out":
                    return OPT_OUT;
                default:
                    return new ConsentType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            OPT_OUT,

            OPT_IN,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitOptOut();

            T visitOptIn();

            T visitUnknown(String unknownType);
        }
    }

    public static final class ContentTypesItem {
        public static final ContentTypesItem EMAIL = new ContentTypesItem(Value.EMAIL, "email");

        public static final ContentTypesItem SMS_MESSAGE = new ContentTypesItem(Value.SMS_MESSAGE, "sms_message");

        private final Value value;

        private final String string;

        ContentTypesItem(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof ContentTypesItem && this.string.equals(((ContentTypesItem) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case EMAIL:
                    return visitor.visitEmail();
                case SMS_MESSAGE:
                    return visitor.visitSmsMessage();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static ContentTypesItem valueOf(String value) {
            switch (value) {
                case "email":
                    return EMAIL;
                case "sms_message":
                    return SMS_MESSAGE;
                default:
                    return new ContentTypesItem(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            EMAIL,

            SMS_MESSAGE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitEmail();

            T visitSmsMessage();

            T visitUnknown(String unknownType);
        }
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");

        public static final State ARCHIVED = new State(Value.ARCHIVED, "archived");

        public static final State DRAFT = new State(Value.DRAFT, "draft");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case LIVE:
                    return visitor.visitLive();
                case ARCHIVED:
                    return visitor.visitArchived();
                case DRAFT:
                    return visitor.visitDraft();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live":
                    return LIVE;
                case "archived":
                    return ARCHIVED;
                case "draft":
                    return DRAFT;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            LIVE,

            DRAFT,

            ARCHIVED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitLive();

            T visitDraft();

            T visitArchived();

            T visitUnknown(String unknownType);
        }
    }
}
