/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ArticleStatistics.Builder.class)
public final class ArticleStatistics {
    private final Optional<String> type;

    private final Optional<Integer> views;

    private final Optional<Integer> conversions;

    private final Optional<Integer> reactions;

    private final Optional<Float> happyReactionPercentage;

    private final Optional<Float> neutralReactionPercentage;

    private final Optional<Float> sadReactionPercentage;

    private final Map<String, Object> additionalProperties;

    private ArticleStatistics(
            Optional<String> type,
            Optional<Integer> views,
            Optional<Integer> conversions,
            Optional<Integer> reactions,
            Optional<Float> happyReactionPercentage,
            Optional<Float> neutralReactionPercentage,
            Optional<Float> sadReactionPercentage,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.views = views;
        this.conversions = conversions;
        this.reactions = reactions;
        this.happyReactionPercentage = happyReactionPercentage;
        this.neutralReactionPercentage = neutralReactionPercentage;
        this.sadReactionPercentage = sadReactionPercentage;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>article_statistics</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The number of total views the article has received.
     */
    @JsonProperty("views")
    public Optional<Integer> getViews() {
        return views;
    }

    /**
     * @return The number of conversations started from the article.
     */
    @JsonProperty("conversions")
    public Optional<Integer> getConversions() {
        return conversions;
    }

    /**
     * @return The number of total reactions the article has received.
     */
    @JsonProperty("reactions")
    public Optional<Integer> getReactions() {
        return reactions;
    }

    /**
     * @return The percentage of happy reactions the article has received against other types of reaction.
     */
    @JsonProperty("happy_reaction_percentage")
    public Optional<Float> getHappyReactionPercentage() {
        return happyReactionPercentage;
    }

    /**
     * @return The percentage of neutral reactions the article has received against other types of reaction.
     */
    @JsonProperty("neutral_reaction_percentage")
    public Optional<Float> getNeutralReactionPercentage() {
        return neutralReactionPercentage;
    }

    /**
     * @return The percentage of sad reactions the article has received against other types of reaction.
     */
    @JsonProperty("sad_reaction_percentage")
    public Optional<Float> getSadReactionPercentage() {
        return sadReactionPercentage;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ArticleStatistics && equalTo((ArticleStatistics) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleStatistics other) {
        return type.equals(other.type)
                && views.equals(other.views)
                && conversions.equals(other.conversions)
                && reactions.equals(other.reactions)
                && happyReactionPercentage.equals(other.happyReactionPercentage)
                && neutralReactionPercentage.equals(other.neutralReactionPercentage)
                && sadReactionPercentage.equals(other.sadReactionPercentage);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.views,
                this.conversions,
                this.reactions,
                this.happyReactionPercentage,
                this.neutralReactionPercentage,
                this.sadReactionPercentage);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<Integer> views = Optional.empty();

        private Optional<Integer> conversions = Optional.empty();

        private Optional<Integer> reactions = Optional.empty();

        private Optional<Float> happyReactionPercentage = Optional.empty();

        private Optional<Float> neutralReactionPercentage = Optional.empty();

        private Optional<Float> sadReactionPercentage = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ArticleStatistics other) {
            type(other.getType());
            views(other.getViews());
            conversions(other.getConversions());
            reactions(other.getReactions());
            happyReactionPercentage(other.getHappyReactionPercentage());
            neutralReactionPercentage(other.getNeutralReactionPercentage());
            sadReactionPercentage(other.getSadReactionPercentage());
            return this;
        }

        /**
         * <p>The type of object - <code>article_statistics</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The number of total views the article has received.</p>
         */
        @JsonSetter(value = "views", nulls = Nulls.SKIP)
        public Builder views(Optional<Integer> views) {
            this.views = views;
            return this;
        }

        public Builder views(Integer views) {
            this.views = Optional.ofNullable(views);
            return this;
        }

        /**
         * <p>The number of conversations started from the article.</p>
         */
        @JsonSetter(value = "conversions", nulls = Nulls.SKIP)
        public Builder conversions(Optional<Integer> conversions) {
            this.conversions = conversions;
            return this;
        }

        public Builder conversions(Integer conversions) {
            this.conversions = Optional.ofNullable(conversions);
            return this;
        }

        /**
         * <p>The number of total reactions the article has received.</p>
         */
        @JsonSetter(value = "reactions", nulls = Nulls.SKIP)
        public Builder reactions(Optional<Integer> reactions) {
            this.reactions = reactions;
            return this;
        }

        public Builder reactions(Integer reactions) {
            this.reactions = Optional.ofNullable(reactions);
            return this;
        }

        /**
         * <p>The percentage of happy reactions the article has received against other types of reaction.</p>
         */
        @JsonSetter(value = "happy_reaction_percentage", nulls = Nulls.SKIP)
        public Builder happyReactionPercentage(Optional<Float> happyReactionPercentage) {
            this.happyReactionPercentage = happyReactionPercentage;
            return this;
        }

        public Builder happyReactionPercentage(Float happyReactionPercentage) {
            this.happyReactionPercentage = Optional.ofNullable(happyReactionPercentage);
            return this;
        }

        /**
         * <p>The percentage of neutral reactions the article has received against other types of reaction.</p>
         */
        @JsonSetter(value = "neutral_reaction_percentage", nulls = Nulls.SKIP)
        public Builder neutralReactionPercentage(Optional<Float> neutralReactionPercentage) {
            this.neutralReactionPercentage = neutralReactionPercentage;
            return this;
        }

        public Builder neutralReactionPercentage(Float neutralReactionPercentage) {
            this.neutralReactionPercentage = Optional.ofNullable(neutralReactionPercentage);
            return this;
        }

        /**
         * <p>The percentage of sad reactions the article has received against other types of reaction.</p>
         */
        @JsonSetter(value = "sad_reaction_percentage", nulls = Nulls.SKIP)
        public Builder sadReactionPercentage(Optional<Float> sadReactionPercentage) {
            this.sadReactionPercentage = sadReactionPercentage;
            return this;
        }

        public Builder sadReactionPercentage(Float sadReactionPercentage) {
            this.sadReactionPercentage = Optional.ofNullable(sadReactionPercentage);
            return this;
        }

        public ArticleStatistics build() {
            return new ArticleStatistics(
                    type,
                    views,
                    conversions,
                    reactions,
                    happyReactionPercentage,
                    neutralReactionPercentage,
                    sadReactionPercentage,
                    additionalProperties);
        }
    }
}
