/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.aicontentsource.types.ContentSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContentSourcesList.Builder.class)
public final class ContentSourcesList {
    private final Optional<String> type;

    private final Optional<Integer> totalCount;

    private final Optional<List<ContentSource>> contentSources;

    private final Map<String, Object> additionalProperties;

    private ContentSourcesList(
            Optional<String> type,
            Optional<Integer> totalCount,
            Optional<List<ContentSource>> contentSources,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.totalCount = totalCount;
        this.contentSources = contentSources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The total number of content sources used by AI Agent in the conversation.
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    /**
     * @return The content sources used by AI Agent in the conversation.
     */
    @JsonProperty("content_sources")
    public Optional<List<ContentSource>> getContentSources() {
        return contentSources;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContentSourcesList && equalTo((ContentSourcesList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSourcesList other) {
        return type.equals(other.type)
                && totalCount.equals(other.totalCount)
                && contentSources.equals(other.contentSources);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.totalCount, this.contentSources);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<List<ContentSource>> contentSources = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ContentSourcesList other) {
            type(other.getType());
            totalCount(other.getTotalCount());
            contentSources(other.getContentSources());
            return this;
        }

        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The total number of content sources used by AI Agent in the conversation.</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        /**
         * <p>The content sources used by AI Agent in the conversation.</p>
         */
        @JsonSetter(value = "content_sources", nulls = Nulls.SKIP)
        public Builder contentSources(Optional<List<ContentSource>> contentSources) {
            this.contentSources = contentSources;
            return this;
        }

        public Builder contentSources(List<ContentSource> contentSources) {
            this.contentSources = Optional.ofNullable(contentSources);
            return this;
        }

        public ContentSourcesList build() {
            return new ContentSourcesList(type, totalCount, contentSources, additionalProperties);
        }
    }
}
