/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataEventSummary.Builder.class)
public final class DataEventSummary {
    private final Optional<String> type;

    private final Optional<String> email;

    private final Optional<String> intercomUserId;

    private final Optional<String> userId;

    private final Optional<List<Optional<DataEventSummaryItem>>> events;

    private final Map<String, Object> additionalProperties;

    private DataEventSummary(
            Optional<String> type,
            Optional<String> email,
            Optional<String> intercomUserId,
            Optional<String> userId,
            Optional<List<Optional<DataEventSummaryItem>>> events,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.email = email;
        this.intercomUserId = intercomUserId;
        this.userId = userId;
        this.events = events;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The email address of the user
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return The Intercom user ID of the user
     */
    @JsonProperty("intercom_user_id")
    public Optional<String> getIntercomUserId() {
        return intercomUserId;
    }

    /**
     * @return The user ID of the user
     */
    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    /**
     * @return A summary of data events
     */
    @JsonProperty("events")
    public Optional<List<Optional<DataEventSummaryItem>>> getEvents() {
        return events;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataEventSummary && equalTo((DataEventSummary) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventSummary other) {
        return type.equals(other.type)
                && email.equals(other.email)
                && intercomUserId.equals(other.intercomUserId)
                && userId.equals(other.userId)
                && events.equals(other.events);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.email, this.intercomUserId, this.userId, this.events);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> intercomUserId = Optional.empty();

        private Optional<String> userId = Optional.empty();

        private Optional<List<Optional<DataEventSummaryItem>>> events = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DataEventSummary other) {
            type(other.getType());
            email(other.getEmail());
            intercomUserId(other.getIntercomUserId());
            userId(other.getUserId());
            events(other.getEvents());
            return this;
        }

        /**
         * <p>The type of the object</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The email address of the user</p>
         */
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The Intercom user ID of the user</p>
         */
        @JsonSetter(value = "intercom_user_id", nulls = Nulls.SKIP)
        public Builder intercomUserId(Optional<String> intercomUserId) {
            this.intercomUserId = intercomUserId;
            return this;
        }

        public Builder intercomUserId(String intercomUserId) {
            this.intercomUserId = Optional.ofNullable(intercomUserId);
            return this;
        }

        /**
         * <p>The user ID of the user</p>
         */
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        /**
         * <p>A summary of data events</p>
         */
        @JsonSetter(value = "events", nulls = Nulls.SKIP)
        public Builder events(Optional<List<Optional<DataEventSummaryItem>>> events) {
            this.events = events;
            return this;
        }

        public Builder events(List<Optional<DataEventSummaryItem>> events) {
            this.events = Optional.ofNullable(events);
            return this;
        }

        public DataEventSummary build() {
            return new DataEventSummary(type, email, intercomUserId, userId, events, additionalProperties);
        }
    }
}
