/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SnoozeConversationRequest.Builder.class)
public final class SnoozeConversationRequest {
    private final String adminId;

    private final int snoozedUntil;

    private final Map<String, Object> additionalProperties;

    private SnoozeConversationRequest(String adminId, int snoozedUntil, Map<String, Object> additionalProperties) {
        this.adminId = adminId;
        this.snoozedUntil = snoozedUntil;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the admin who is performing the action.
     */
    @JsonProperty("admin_id")
    public String getAdminId() {
        return adminId;
    }

    /**
     * @return The time you want the conversation to reopen.
     */
    @JsonProperty("snoozed_until")
    public int getSnoozedUntil() {
        return snoozedUntil;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SnoozeConversationRequest && equalTo((SnoozeConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SnoozeConversationRequest other) {
        return adminId.equals(other.adminId) && snoozedUntil == other.snoozedUntil;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.adminId, this.snoozedUntil);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AdminIdStage builder() {
        return new Builder();
    }

    public interface AdminIdStage {
        /**
         * The id of the admin who is performing the action.
         */
        SnoozedUntilStage adminId(@NotNull String adminId);

        Builder from(SnoozeConversationRequest other);
    }

    public interface SnoozedUntilStage {
        /**
         * The time you want the conversation to reopen.
         */
        _FinalStage snoozedUntil(int snoozedUntil);
    }

    public interface _FinalStage {
        SnoozeConversationRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements AdminIdStage, SnoozedUntilStage, _FinalStage {
        private String adminId;

        private int snoozedUntil;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SnoozeConversationRequest other) {
            adminId(other.getAdminId());
            snoozedUntil(other.getSnoozedUntil());
            return this;
        }

        /**
         * The id of the admin who is performing the action.<p>The id of the admin who is performing the action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("admin_id")
        public SnoozedUntilStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        /**
         * The time you want the conversation to reopen.<p>The time you want the conversation to reopen.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("snoozed_until")
        public _FinalStage snoozedUntil(int snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        @java.lang.Override
        public SnoozeConversationRequest build() {
            return new SnoozeConversationRequest(adminId, snoozedUntil, additionalProperties);
        }
    }
}
