/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.teams.types.Team;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TeamList.Builder.class)
public final class TeamList {
    private final Optional<String> type;

    private final Optional<List<Team>> teams;

    private final Map<String, Object> additionalProperties;

    private TeamList(Optional<String> type, Optional<List<Team>> teams, Map<String, Object> additionalProperties) {
        this.type = type;
        this.teams = teams;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return A list of team objects
     */
    @JsonProperty("teams")
    public Optional<List<Team>> getTeams() {
        return teams;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TeamList && equalTo((TeamList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamList other) {
        return type.equals(other.type) && teams.equals(other.teams);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.teams);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Team>> teams = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TeamList other) {
            type(other.getType());
            teams(other.getTeams());
            return this;
        }

        /**
         * <p>The type of the object</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>A list of team objects</p>
         */
        @JsonSetter(value = "teams", nulls = Nulls.SKIP)
        public Builder teams(Optional<List<Team>> teams) {
            this.teams = teams;
            return this;
        }

        public Builder teams(List<Team> teams) {
            this.teams = Optional.ofNullable(teams);
            return this;
        }

        public TeamList build() {
            return new TeamList(type, teams, additionalProperties);
        }
    }
}
