/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketTypeAttribute.Builder.class)
public final class TicketTypeAttribute {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> workspaceId;

    private final Optional<String> name;

    private final Optional<String> description;

    private final Optional<String> dataType;

    private final Optional<Map<String, Object>> inputOptions;

    private final Optional<Integer> order;

    private final Optional<Boolean> requiredToCreate;

    private final Optional<Boolean> requiredToCreateForContacts;

    private final Optional<Boolean> visibleOnCreate;

    private final Optional<Boolean> visibleToContacts;

    private final Optional<Boolean> default_;

    private final Optional<Integer> ticketTypeId;

    private final Optional<Boolean> archived;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Map<String, Object> additionalProperties;

    private TicketTypeAttribute(
            Optional<String> type,
            Optional<String> id,
            Optional<String> workspaceId,
            Optional<String> name,
            Optional<String> description,
            Optional<String> dataType,
            Optional<Map<String, Object>> inputOptions,
            Optional<Integer> order,
            Optional<Boolean> requiredToCreate,
            Optional<Boolean> requiredToCreateForContacts,
            Optional<Boolean> visibleOnCreate,
            Optional<Boolean> visibleToContacts,
            Optional<Boolean> default_,
            Optional<Integer> ticketTypeId,
            Optional<Boolean> archived,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.workspaceId = workspaceId;
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.inputOptions = inputOptions;
        this.order = order;
        this.requiredToCreate = requiredToCreate;
        this.requiredToCreateForContacts = requiredToCreateForContacts;
        this.visibleOnCreate = visibleOnCreate;
        this.visibleToContacts = visibleToContacts;
        this.default_ = default_;
        this.ticketTypeId = ticketTypeId;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>ticket_type_attribute</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id representing the ticket type attribute.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The id of the workspace that the ticket type attribute belongs to.
     */
    @JsonProperty("workspace_id")
    public Optional<String> getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The name of the ticket type attribute
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The description of the ticket type attribute
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return The type of the data attribute (allowed values: &quot;string list integer decimal boolean datetime files&quot;)
     */
    @JsonProperty("data_type")
    public Optional<String> getDataType() {
        return dataType;
    }

    /**
     * @return Input options for the attribute
     */
    @JsonProperty("input_options")
    public Optional<Map<String, Object>> getInputOptions() {
        return inputOptions;
    }

    /**
     * @return The order of the attribute against other attributes
     */
    @JsonProperty("order")
    public Optional<Integer> getOrder() {
        return order;
    }

    /**
     * @return Whether the attribute is required or not for teammates.
     */
    @JsonProperty("required_to_create")
    public Optional<Boolean> getRequiredToCreate() {
        return requiredToCreate;
    }

    /**
     * @return Whether the attribute is required or not for contacts.
     */
    @JsonProperty("required_to_create_for_contacts")
    public Optional<Boolean> getRequiredToCreateForContacts() {
        return requiredToCreateForContacts;
    }

    /**
     * @return Whether the attribute is visible or not to teammates.
     */
    @JsonProperty("visible_on_create")
    public Optional<Boolean> getVisibleOnCreate() {
        return visibleOnCreate;
    }

    /**
     * @return Whether the attribute is visible or not to contacts.
     */
    @JsonProperty("visible_to_contacts")
    public Optional<Boolean> getVisibleToContacts() {
        return visibleToContacts;
    }

    /**
     * @return Whether the attribute is built in or not.
     */
    @JsonProperty("default")
    public Optional<Boolean> getDefault() {
        return default_;
    }

    /**
     * @return The id of the ticket type that the attribute belongs to.
     */
    @JsonProperty("ticket_type_id")
    public Optional<Integer> getTicketTypeId() {
        return ticketTypeId;
    }

    /**
     * @return Whether the ticket type attribute is archived or not.
     */
    @JsonProperty("archived")
    public Optional<Boolean> getArchived() {
        return archived;
    }

    /**
     * @return The date and time the ticket type attribute was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The date and time the ticket type attribute was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketTypeAttribute && equalTo((TicketTypeAttribute) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketTypeAttribute other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && name.equals(other.name)
                && description.equals(other.description)
                && dataType.equals(other.dataType)
                && inputOptions.equals(other.inputOptions)
                && order.equals(other.order)
                && requiredToCreate.equals(other.requiredToCreate)
                && requiredToCreateForContacts.equals(other.requiredToCreateForContacts)
                && visibleOnCreate.equals(other.visibleOnCreate)
                && visibleToContacts.equals(other.visibleToContacts)
                && default_.equals(other.default_)
                && ticketTypeId.equals(other.ticketTypeId)
                && archived.equals(other.archived)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.workspaceId,
                this.name,
                this.description,
                this.dataType,
                this.inputOptions,
                this.order,
                this.requiredToCreate,
                this.requiredToCreateForContacts,
                this.visibleOnCreate,
                this.visibleToContacts,
                this.default_,
                this.ticketTypeId,
                this.archived,
                this.createdAt,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> workspaceId = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<String> dataType = Optional.empty();

        private Optional<Map<String, Object>> inputOptions = Optional.empty();

        private Optional<Integer> order = Optional.empty();

        private Optional<Boolean> requiredToCreate = Optional.empty();

        private Optional<Boolean> requiredToCreateForContacts = Optional.empty();

        private Optional<Boolean> visibleOnCreate = Optional.empty();

        private Optional<Boolean> visibleToContacts = Optional.empty();

        private Optional<Boolean> default_ = Optional.empty();

        private Optional<Integer> ticketTypeId = Optional.empty();

        private Optional<Boolean> archived = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketTypeAttribute other) {
            type(other.getType());
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            name(other.getName());
            description(other.getDescription());
            dataType(other.getDataType());
            inputOptions(other.getInputOptions());
            order(other.getOrder());
            requiredToCreate(other.getRequiredToCreate());
            requiredToCreateForContacts(other.getRequiredToCreateForContacts());
            visibleOnCreate(other.getVisibleOnCreate());
            visibleToContacts(other.getVisibleToContacts());
            default_(other.getDefault());
            ticketTypeId(other.getTicketTypeId());
            archived(other.getArchived());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>ticket_type_attribute</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id representing the ticket type attribute.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The id of the workspace that the ticket type attribute belongs to.</p>
         */
        @JsonSetter(value = "workspace_id", nulls = Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        /**
         * <p>The name of the ticket type attribute</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The description of the ticket type attribute</p>
         */
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The type of the data attribute (allowed values: &quot;string list integer decimal boolean datetime files&quot;)</p>
         */
        @JsonSetter(value = "data_type", nulls = Nulls.SKIP)
        public Builder dataType(Optional<String> dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = Optional.ofNullable(dataType);
            return this;
        }

        /**
         * <p>Input options for the attribute</p>
         */
        @JsonSetter(value = "input_options", nulls = Nulls.SKIP)
        public Builder inputOptions(Optional<Map<String, Object>> inputOptions) {
            this.inputOptions = inputOptions;
            return this;
        }

        public Builder inputOptions(Map<String, Object> inputOptions) {
            this.inputOptions = Optional.ofNullable(inputOptions);
            return this;
        }

        /**
         * <p>The order of the attribute against other attributes</p>
         */
        @JsonSetter(value = "order", nulls = Nulls.SKIP)
        public Builder order(Optional<Integer> order) {
            this.order = order;
            return this;
        }

        public Builder order(Integer order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        /**
         * <p>Whether the attribute is required or not for teammates.</p>
         */
        @JsonSetter(value = "required_to_create", nulls = Nulls.SKIP)
        public Builder requiredToCreate(Optional<Boolean> requiredToCreate) {
            this.requiredToCreate = requiredToCreate;
            return this;
        }

        public Builder requiredToCreate(Boolean requiredToCreate) {
            this.requiredToCreate = Optional.ofNullable(requiredToCreate);
            return this;
        }

        /**
         * <p>Whether the attribute is required or not for contacts.</p>
         */
        @JsonSetter(value = "required_to_create_for_contacts", nulls = Nulls.SKIP)
        public Builder requiredToCreateForContacts(Optional<Boolean> requiredToCreateForContacts) {
            this.requiredToCreateForContacts = requiredToCreateForContacts;
            return this;
        }

        public Builder requiredToCreateForContacts(Boolean requiredToCreateForContacts) {
            this.requiredToCreateForContacts = Optional.ofNullable(requiredToCreateForContacts);
            return this;
        }

        /**
         * <p>Whether the attribute is visible or not to teammates.</p>
         */
        @JsonSetter(value = "visible_on_create", nulls = Nulls.SKIP)
        public Builder visibleOnCreate(Optional<Boolean> visibleOnCreate) {
            this.visibleOnCreate = visibleOnCreate;
            return this;
        }

        public Builder visibleOnCreate(Boolean visibleOnCreate) {
            this.visibleOnCreate = Optional.ofNullable(visibleOnCreate);
            return this;
        }

        /**
         * <p>Whether the attribute is visible or not to contacts.</p>
         */
        @JsonSetter(value = "visible_to_contacts", nulls = Nulls.SKIP)
        public Builder visibleToContacts(Optional<Boolean> visibleToContacts) {
            this.visibleToContacts = visibleToContacts;
            return this;
        }

        public Builder visibleToContacts(Boolean visibleToContacts) {
            this.visibleToContacts = Optional.ofNullable(visibleToContacts);
            return this;
        }

        /**
         * <p>Whether the attribute is built in or not.</p>
         */
        @JsonSetter(value = "default", nulls = Nulls.SKIP)
        public Builder default_(Optional<Boolean> default_) {
            this.default_ = default_;
            return this;
        }

        public Builder default_(Boolean default_) {
            this.default_ = Optional.ofNullable(default_);
            return this;
        }

        /**
         * <p>The id of the ticket type that the attribute belongs to.</p>
         */
        @JsonSetter(value = "ticket_type_id", nulls = Nulls.SKIP)
        public Builder ticketTypeId(Optional<Integer> ticketTypeId) {
            this.ticketTypeId = ticketTypeId;
            return this;
        }

        public Builder ticketTypeId(Integer ticketTypeId) {
            this.ticketTypeId = Optional.ofNullable(ticketTypeId);
            return this;
        }

        /**
         * <p>Whether the ticket type attribute is archived or not.</p>
         */
        @JsonSetter(value = "archived", nulls = Nulls.SKIP)
        public Builder archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        /**
         * <p>The date and time the ticket type attribute was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The date and time the ticket type attribute was last updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public TicketTypeAttribute build() {
            return new TicketTypeAttribute(
                    type,
                    id,
                    workspaceId,
                    name,
                    description,
                    dataType,
                    inputOptions,
                    order,
                    requiredToCreate,
                    requiredToCreateForContacts,
                    visibleOnCreate,
                    visibleToContacts,
                    default_,
                    ticketTypeId,
                    archived,
                    createdAt,
                    updatedAt,
                    additionalProperties);
        }
    }
}
