/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.visitors;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.contacts.types.Contact;
import com.intercom.api.resources.unstable.types.Visitor;
import com.intercom.api.resources.unstable.visitors.requests.ConvertVisitorRequest;
import com.intercom.api.resources.unstable.visitors.requests.RetrieveVisitorWithUserIdRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncVisitorsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawVisitorsClient rawClient;

    public AsyncVisitorsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawVisitorsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawVisitorsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch the details of a single visitor.
     */
    public CompletableFuture<Optional<Visitor>> retrieveVisitorWithUserId(RetrieveVisitorWithUserIdRequest request) {
        return this.rawClient.retrieveVisitorWithUserId(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single visitor.
     */
    public CompletableFuture<Optional<Visitor>> retrieveVisitorWithUserId(
            RetrieveVisitorWithUserIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveVisitorWithUserId(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Sending a PUT request to <code>/visitors</code> will result in an update of an existing Visitor.
     * <p><strong>Option 1.</strong> You can update a visitor by passing in the <code>user_id</code> of the visitor in the Request body.</p>
     * <p><strong>Option 2.</strong> You can update a visitor by passing in the <code>id</code> of the visitor in the Request body.</p>
     */
    public CompletableFuture<Optional<Visitor>> updateVisitor(Object request) {
        return this.rawClient.updateVisitor(request).thenApply(response -> response.body());
    }

    /**
     * Sending a PUT request to <code>/visitors</code> will result in an update of an existing Visitor.
     * <p><strong>Option 1.</strong> You can update a visitor by passing in the <code>user_id</code> of the visitor in the Request body.</p>
     * <p><strong>Option 2.</strong> You can update a visitor by passing in the <code>id</code> of the visitor in the Request body.</p>
     */
    public CompletableFuture<Optional<Visitor>> updateVisitor(Object request, RequestOptions requestOptions) {
        return this.rawClient.updateVisitor(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can merge a Visitor to a Contact of role type <code>lead</code> or <code>user</code>.
     * <blockquote>
     * <p>📘 What happens upon a visitor being converted?</p>
     * <p>If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.</p>
     * </blockquote>
     */
    public CompletableFuture<Contact> convertVisitor(ConvertVisitorRequest request) {
        return this.rawClient.convertVisitor(request).thenApply(response -> response.body());
    }

    /**
     * You can merge a Visitor to a Contact of role type <code>lead</code> or <code>user</code>.
     * <blockquote>
     * <p>📘 What happens upon a visitor being converted?</p>
     * <p>If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.</p>
     * </blockquote>
     */
    public CompletableFuture<Contact> convertVisitor(ConvertVisitorRequest request, RequestOptions requestOptions) {
        return this.rawClient.convertVisitor(request, requestOptions).thenApply(response -> response.body());
    }
}
