/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class ActionComponent {
    private final Value value;

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    private ActionComponent(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return value.visit(visitor);
    }

    public static ActionComponent sheet(SheetActionComponent value) {
        return new ActionComponent(new SheetValue(value));
    }

    public static ActionComponent url(UrlActionComponent value) {
        return new ActionComponent(new UrlValue(value));
    }

    public static ActionComponent submit(SubmitActionComponent value) {
        return new ActionComponent(new SubmitValue(value));
    }

    public boolean isSheet() {
        return value instanceof SheetValue;
    }

    public boolean isUrl() {
        return value instanceof UrlValue;
    }

    public boolean isSubmit() {
        return value instanceof SubmitValue;
    }

    public boolean _isUnknown() {
        return value instanceof _UnknownValue;
    }

    public Optional<SheetActionComponent> getSheet() {
        if (isSheet()) {
            return Optional.of(((SheetValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<UrlActionComponent> getUrl() {
        if (isUrl()) {
            return Optional.of(((UrlValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<SubmitActionComponent> getSubmit() {
        if (isSubmit()) {
            return Optional.of(((SubmitValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (_isUnknown()) {
            return Optional.of(((_UnknownValue) value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    public interface Visitor<T> {
        T visitSheet(SheetActionComponent sheet);

        T visitUrl(UrlActionComponent url);

        T visitSubmit(SubmitActionComponent submit);

        T _visitUnknown(Object unknownType);
    }

    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", visible = true, defaultImpl = _UnknownValue.class)
    @JsonSubTypes({
        @JsonSubTypes.Type(SheetValue.class),
        @JsonSubTypes.Type(UrlValue.class),
        @JsonSubTypes.Type(SubmitValue.class)
    })
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface Value {
        <T> T visit(Visitor<T> visitor);
    }

    @JsonTypeName("sheet")
    @JsonIgnoreProperties("type")
    private static final class SheetValue implements Value {
        @JsonUnwrapped
        private SheetActionComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private SheetValue() {}

        private SheetValue(SheetActionComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSheet(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof SheetValue && equalTo((SheetValue) other);
        }

        private boolean equalTo(SheetValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "ActionComponent{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("url")
    @JsonIgnoreProperties("type")
    private static final class UrlValue implements Value {
        @JsonUnwrapped
        private UrlActionComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private UrlValue() {}

        private UrlValue(UrlActionComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitUrl(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof UrlValue && equalTo((UrlValue) other);
        }

        private boolean equalTo(UrlValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "ActionComponent{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("submit")
    @JsonIgnoreProperties("type")
    private static final class SubmitValue implements Value {
        @JsonUnwrapped
        private SubmitActionComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private SubmitValue() {}

        private SubmitValue(SubmitActionComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSubmit(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof SubmitValue && equalTo((SubmitValue) other);
        }

        private boolean equalTo(SubmitValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "ActionComponent{" + "value: " + value + "}";
        }
    }

    @JsonIgnoreProperties("type")
    private static final class _UnknownValue implements Value {
        private String type;

        @JsonValue
        private Object value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty("value") Object value) {}

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
        }

        private boolean equalTo(_UnknownValue other) {
            return type.equals(other.type) && value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        @java.lang.Override
        public String toString() {
            return "ActionComponent{" + "type: " + type + ", value: " + value + "}";
        }
    }
}
