/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AdminWithApp.Builder.class)
public final class AdminWithApp {
    private final String id;

    private final String name;

    private final String email;

    private final String jobTitle;

    private final boolean awayModeEnabled;

    private final boolean awayModeReassign;

    private final boolean hasInboxSeat;

    private final List<Integer> teamIds;

    private final Optional<Avatar> avatar;

    private final Optional<Boolean> emailVerified;

    private final Optional<App> app;

    private final Map<String, Object> additionalProperties;

    private AdminWithApp(
            String id,
            String name,
            String email,
            String jobTitle,
            boolean awayModeEnabled,
            boolean awayModeReassign,
            boolean hasInboxSeat,
            List<Integer> teamIds,
            Optional<Avatar> avatar,
            Optional<Boolean> emailVerified,
            Optional<App> app,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.jobTitle = jobTitle;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.hasInboxSeat = hasInboxSeat;
        this.teamIds = teamIds;
        this.avatar = avatar;
        this.emailVerified = emailVerified;
        this.app = app;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>admin</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "admin";
    }

    /**
     * @return The id representing the admin.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the admin.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The email of the admin.
     */
    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    /**
     * @return The job title of the admin.
     */
    @JsonProperty("job_title")
    public String getJobTitle() {
        return jobTitle;
    }

    /**
     * @return Identifies if this admin is currently set in away mode.
     */
    @JsonProperty("away_mode_enabled")
    public boolean getAwayModeEnabled() {
        return awayModeEnabled;
    }

    /**
     * @return Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
     */
    @JsonProperty("away_mode_reassign")
    public boolean getAwayModeReassign() {
        return awayModeReassign;
    }

    /**
     * @return Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
     */
    @JsonProperty("has_inbox_seat")
    public boolean getHasInboxSeat() {
        return hasInboxSeat;
    }

    /**
     * @return This is a list of ids of the teams that this admin is part of.
     */
    @JsonProperty("team_ids")
    public List<Integer> getTeamIds() {
        return teamIds;
    }

    /**
     * @return This object represents the avatar associated with the admin.
     */
    @JsonProperty("avatar")
    public Optional<Avatar> getAvatar() {
        return avatar;
    }

    /**
     * @return Identifies if this admin's email is verified.
     */
    @JsonProperty("email_verified")
    public Optional<Boolean> getEmailVerified() {
        return emailVerified;
    }

    /**
     * @return App that the admin belongs to.
     */
    @JsonProperty("app")
    public Optional<App> getApp() {
        return app;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AdminWithApp && equalTo((AdminWithApp) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdminWithApp other) {
        return id.equals(other.id)
                && name.equals(other.name)
                && email.equals(other.email)
                && jobTitle.equals(other.jobTitle)
                && awayModeEnabled == other.awayModeEnabled
                && awayModeReassign == other.awayModeReassign
                && hasInboxSeat == other.hasInboxSeat
                && teamIds.equals(other.teamIds)
                && avatar.equals(other.avatar)
                && emailVerified.equals(other.emailVerified)
                && app.equals(other.app);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.name,
                this.email,
                this.jobTitle,
                this.awayModeEnabled,
                this.awayModeReassign,
                this.hasInboxSeat,
                this.teamIds,
                this.avatar,
                this.emailVerified,
                this.app);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id representing the admin.
         */
        NameStage id(@NotNull String id);

        Builder from(AdminWithApp other);
    }

    public interface NameStage {
        /**
         * The name of the admin.
         */
        EmailStage name(@NotNull String name);
    }

    public interface EmailStage {
        /**
         * The email of the admin.
         */
        JobTitleStage email(@NotNull String email);
    }

    public interface JobTitleStage {
        /**
         * The job title of the admin.
         */
        AwayModeEnabledStage jobTitle(@NotNull String jobTitle);
    }

    public interface AwayModeEnabledStage {
        /**
         * Identifies if this admin is currently set in away mode.
         */
        AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled);
    }

    public interface AwayModeReassignStage {
        /**
         * Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
         */
        HasInboxSeatStage awayModeReassign(boolean awayModeReassign);
    }

    public interface HasInboxSeatStage {
        /**
         * Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
         */
        _FinalStage hasInboxSeat(boolean hasInboxSeat);
    }

    public interface _FinalStage {
        AdminWithApp build();

        /**
         * <p>This is a list of ids of the teams that this admin is part of.</p>
         */
        _FinalStage teamIds(List<Integer> teamIds);

        _FinalStage addTeamIds(Integer teamIds);

        _FinalStage addAllTeamIds(List<Integer> teamIds);

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         */
        _FinalStage avatar(Optional<Avatar> avatar);

        _FinalStage avatar(Avatar avatar);

        /**
         * <p>Identifies if this admin's email is verified.</p>
         */
        _FinalStage emailVerified(Optional<Boolean> emailVerified);

        _FinalStage emailVerified(Boolean emailVerified);

        /**
         * <p>App that the admin belongs to.</p>
         */
        _FinalStage app(Optional<App> app);

        _FinalStage app(App app);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    NameStage,
                    EmailStage,
                    JobTitleStage,
                    AwayModeEnabledStage,
                    AwayModeReassignStage,
                    HasInboxSeatStage,
                    _FinalStage {
        private String id;

        private String name;

        private String email;

        private String jobTitle;

        private boolean awayModeEnabled;

        private boolean awayModeReassign;

        private boolean hasInboxSeat;

        private Optional<App> app = Optional.empty();

        private Optional<Boolean> emailVerified = Optional.empty();

        private Optional<Avatar> avatar = Optional.empty();

        private List<Integer> teamIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AdminWithApp other) {
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            jobTitle(other.getJobTitle());
            awayModeEnabled(other.getAwayModeEnabled());
            awayModeReassign(other.getAwayModeReassign());
            hasInboxSeat(other.getHasInboxSeat());
            teamIds(other.getTeamIds());
            avatar(other.getAvatar());
            emailVerified(other.getEmailVerified());
            app(other.getApp());
            return this;
        }

        /**
         * The id representing the admin.<p>The id representing the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The name of the admin.<p>The name of the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public EmailStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The email of the admin.<p>The email of the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("email")
        public JobTitleStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        /**
         * The job title of the admin.<p>The job title of the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("job_title")
        public AwayModeEnabledStage jobTitle(@NotNull String jobTitle) {
            this.jobTitle = Objects.requireNonNull(jobTitle, "jobTitle must not be null");
            return this;
        }

        /**
         * Identifies if this admin is currently set in away mode.<p>Identifies if this admin is currently set in away mode.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("away_mode_enabled")
        public AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        /**
         * Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.<p>Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("away_mode_reassign")
        public HasInboxSeatStage awayModeReassign(boolean awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        /**
         * Identifies if this admin has a paid inbox seat to restrict/allow features that require them.<p>Identifies if this admin has a paid inbox seat to restrict/allow features that require them.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("has_inbox_seat")
        public _FinalStage hasInboxSeat(boolean hasInboxSeat) {
            this.hasInboxSeat = hasInboxSeat;
            return this;
        }

        /**
         * <p>App that the admin belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage app(App app) {
            this.app = Optional.ofNullable(app);
            return this;
        }

        /**
         * <p>App that the admin belongs to.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "app", nulls = Nulls.SKIP)
        public _FinalStage app(Optional<App> app) {
            this.app = app;
            return this;
        }

        /**
         * <p>Identifies if this admin's email is verified.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage emailVerified(Boolean emailVerified) {
            this.emailVerified = Optional.ofNullable(emailVerified);
            return this;
        }

        /**
         * <p>Identifies if this admin's email is verified.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email_verified", nulls = Nulls.SKIP)
        public _FinalStage emailVerified(Optional<Boolean> emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage avatar(Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
        public _FinalStage avatar(Optional<Avatar> avatar) {
            this.avatar = avatar;
            return this;
        }

        /**
         * <p>This is a list of ids of the teams that this admin is part of.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllTeamIds(List<Integer> teamIds) {
            this.teamIds.addAll(teamIds);
            return this;
        }

        /**
         * <p>This is a list of ids of the teams that this admin is part of.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addTeamIds(Integer teamIds) {
            this.teamIds.add(teamIds);
            return this;
        }

        /**
         * <p>This is a list of ids of the teams that this admin is part of.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "team_ids", nulls = Nulls.SKIP)
        public _FinalStage teamIds(List<Integer> teamIds) {
            this.teamIds.clear();
            this.teamIds.addAll(teamIds);
            return this;
        }

        @java.lang.Override
        public AdminWithApp build() {
            return new AdminWithApp(
                    id,
                    name,
                    email,
                    jobTitle,
                    awayModeEnabled,
                    awayModeReassign,
                    hasInboxSeat,
                    teamIds,
                    avatar,
                    emailVerified,
                    app,
                    additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Avatar.Builder.class)
    public static final class Avatar {
        private final Optional<String> type;

        private final Optional<String> imageUrl;

        private final Map<String, Object> additionalProperties;

        private Avatar(Optional<String> type, Optional<String> imageUrl, Map<String, Object> additionalProperties) {
            this.type = type;
            this.imageUrl = imageUrl;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return This is a string that identifies the type of the object. It will always have the value <code>avatar</code>.
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return This object represents the avatar associated with the admin.
         */
        @JsonProperty("image_url")
        public Optional<String> getImageUrl() {
            return imageUrl;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Avatar && equalTo((Avatar) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Avatar other) {
            return type.equals(other.type) && imageUrl.equals(other.imageUrl);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.imageUrl);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> imageUrl = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Avatar other) {
                type(other.getType());
                imageUrl(other.getImageUrl());
                return this;
            }

            /**
             * <p>This is a string that identifies the type of the object. It will always have the value <code>avatar</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>This object represents the avatar associated with the admin.</p>
             */
            @JsonSetter(value = "image_url", nulls = Nulls.SKIP)
            public Builder imageUrl(Optional<String> imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = Optional.ofNullable(imageUrl);
                return this;
            }

            public Avatar build() {
                return new Avatar(type, imageUrl, additionalProperties);
            }
        }
    }
}
