/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ArticleContent.Builder.class)
public final class ArticleContent {
    private final String title;

    private final String description;

    private final String body;

    private final int authorId;

    private final State state;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> url;

    private final Map<String, Object> additionalProperties;

    private ArticleContent(
            String title,
            String description,
            String body,
            int authorId,
            State state,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> url,
            Map<String, Object> additionalProperties) {
        this.title = title;
        this.description = description;
        this.body = body;
        this.authorId = authorId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>article_content</code> .
     */
    @JsonProperty("type")
    public String getType() {
        return "article_content";
    }

    /**
     * @return The title of the article.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The description of the article.
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * @return The body of the article.
     */
    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    /**
     * @return The ID of the author of the article.
     */
    @JsonProperty("author_id")
    public int getAuthorId() {
        return authorId;
    }

    /**
     * @return Whether the article is <code>published</code> or is a <code>draft</code> .
     */
    @JsonProperty("state")
    public State getState() {
        return state;
    }

    /**
     * @return The time when the article was created (seconds).
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the article was last updated (seconds).
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The URL of the article.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ArticleContent && equalTo((ArticleContent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleContent other) {
        return title.equals(other.title)
                && description.equals(other.description)
                && body.equals(other.body)
                && authorId == other.authorId
                && state.equals(other.state)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.title,
                this.description,
                this.body,
                this.authorId,
                this.state,
                this.createdAt,
                this.updatedAt,
                this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    public interface TitleStage {
        /**
         * The title of the article.
         */
        DescriptionStage title(@NotNull String title);

        Builder from(ArticleContent other);
    }

    public interface DescriptionStage {
        /**
         * The description of the article.
         */
        BodyStage description(@NotNull String description);
    }

    public interface BodyStage {
        /**
         * The body of the article.
         */
        AuthorIdStage body(@NotNull String body);
    }

    public interface AuthorIdStage {
        /**
         * The ID of the author of the article.
         */
        StateStage authorId(int authorId);
    }

    public interface StateStage {
        /**
         * Whether the article is `published` or is a `draft` .
         */
        _FinalStage state(@NotNull State state);
    }

    public interface _FinalStage {
        ArticleContent build();

        /**
         * <p>The time when the article was created (seconds).</p>
         */
        _FinalStage createdAt(Optional<Integer> createdAt);

        _FinalStage createdAt(Integer createdAt);

        /**
         * <p>The time when the article was last updated (seconds).</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        /**
         * <p>The URL of the article.</p>
         */
        _FinalStage url(Optional<String> url);

        _FinalStage url(String url);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements TitleStage, DescriptionStage, BodyStage, AuthorIdStage, StateStage, _FinalStage {
        private String title;

        private String description;

        private String body;

        private int authorId;

        private State state;

        private Optional<String> url = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ArticleContent other) {
            title(other.getTitle());
            description(other.getDescription());
            body(other.getBody());
            authorId(other.getAuthorId());
            state(other.getState());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            url(other.getUrl());
            return this;
        }

        /**
         * The title of the article.<p>The title of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public DescriptionStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * The description of the article.<p>The description of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("description")
        public BodyStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        /**
         * The body of the article.<p>The body of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("body")
        public AuthorIdStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        /**
         * The ID of the author of the article.<p>The ID of the author of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("author_id")
        public StateStage authorId(int authorId) {
            this.authorId = authorId;
            return this;
        }

        /**
         * Whether the article is `published` or is a `draft` .<p>Whether the article is <code>published</code> or is a <code>draft</code> .</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("state")
        public _FinalStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        /**
         * <p>The URL of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>The URL of the article.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        /**
         * <p>The time when the article was last updated (seconds).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The time when the article was last updated (seconds).</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The time when the article was created (seconds).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time when the article was created (seconds).</p>
         */
        @java.lang.Override
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @java.lang.Override
        public ArticleContent build() {
            return new ArticleContent(
                    title, description, body, authorId, state, createdAt, updatedAt, url, additionalProperties);
        }
    }

    public static final class State {
        public static final State PUBLISHED = new State(Value.PUBLISHED, "published");

        public static final State DRAFT = new State(Value.DRAFT, "draft");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case PUBLISHED:
                    return visitor.visitPublished();
                case DRAFT:
                    return visitor.visitDraft();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "published":
                    return PUBLISHED;
                case "draft":
                    return DRAFT;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PUBLISHED,

            DRAFT,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPublished();

            T visitDraft();

            T visitUnknown(String unknownType);
        }
    }
}
