/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using = ConfigureRequest.Deserializer.class)
public final class ConfigureRequest {
    private final Object value;

    private final int type;

    private ConfigureRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((Zero) this.value);
        } else if (this.type == 1) {
            return visitor.visit((ComponentId) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConfigureRequest && equalTo((ConfigureRequest) other);
    }

    private boolean equalTo(ConfigureRequest other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static ConfigureRequest of(Zero value) {
        return new ConfigureRequest(value, 0);
    }

    public static ConfigureRequest of(ComponentId value) {
        return new ConfigureRequest(value, 1);
    }

    public interface Visitor<T> {
        T visit(Zero value);

        T visit(ComponentId value);
    }

    static final class Deserializer extends StdDeserializer<ConfigureRequest> {
        Deserializer() {
            super(ConfigureRequest.class);
        }

        @java.lang.Override
        public ConfigureRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, Zero.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, ComponentId.class));
            } catch (IllegalArgumentException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Zero.Builder.class)
    public static final class Zero {
        private final String workspaceId;

        private final Admin admin;

        private final Context context;

        private final Map<String, Object> additionalProperties;

        private Zero(String workspaceId, Admin admin, Context context, Map<String, Object> additionalProperties) {
            this.workspaceId = workspaceId;
            this.admin = admin;
            this.context = context;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The workspace ID of the teammate. Attribute is app_id for V1.2 and below.
         */
        @JsonProperty("workspace_id")
        public String getWorkspaceId() {
            return workspaceId;
        }

        /**
         * @return The Intercom teammate configuring the app.
         */
        @JsonProperty("admin")
        public Admin getAdmin() {
            return admin;
        }

        /**
         * @return The context of where the app is added, where the user last visited, and information on the Messenger settings.
         */
        @JsonProperty("context")
        public Context getContext() {
            return context;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Zero && equalTo((Zero) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Zero other) {
            return workspaceId.equals(other.workspaceId) && admin.equals(other.admin) && context.equals(other.context);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.workspaceId, this.admin, this.context);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static WorkspaceIdStage builder() {
            return new Builder();
        }

        public interface WorkspaceIdStage {
            /**
             * The workspace ID of the teammate. Attribute is app_id for V1.2 and below.
             */
            AdminStage workspaceId(@NotNull String workspaceId);

            Builder from(Zero other);
        }

        public interface AdminStage {
            /**
             * The Intercom teammate configuring the app.
             */
            ContextStage admin(@NotNull Admin admin);
        }

        public interface ContextStage {
            /**
             * The context of where the app is added, where the user last visited, and information on the Messenger settings.
             */
            _FinalStage context(@NotNull Context context);
        }

        public interface _FinalStage {
            Zero build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements WorkspaceIdStage, AdminStage, ContextStage, _FinalStage {
            private String workspaceId;

            private Admin admin;

            private Context context;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(Zero other) {
                workspaceId(other.getWorkspaceId());
                admin(other.getAdmin());
                context(other.getContext());
                return this;
            }

            /**
             * The workspace ID of the teammate. Attribute is app_id for V1.2 and below.<p>The workspace ID of the teammate. Attribute is app_id for V1.2 and below.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("workspace_id")
            public AdminStage workspaceId(@NotNull String workspaceId) {
                this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
                return this;
            }

            /**
             * The Intercom teammate configuring the app.<p>The Intercom teammate configuring the app.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("admin")
            public ContextStage admin(@NotNull Admin admin) {
                this.admin = Objects.requireNonNull(admin, "admin must not be null");
                return this;
            }

            /**
             * The context of where the app is added, where the user last visited, and information on the Messenger settings.<p>The context of where the app is added, where the user last visited, and information on the Messenger settings.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("context")
            public _FinalStage context(@NotNull Context context) {
                this.context = Objects.requireNonNull(context, "context must not be null");
                return this;
            }

            @java.lang.Override
            public Zero build() {
                return new Zero(workspaceId, admin, context, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = ComponentId.Builder.class)
    public static final class ComponentId {
        private final String workspaceId;

        private final String workspaceRegion;

        private final String componentId;

        private final Admin admin;

        private final Context context;

        private final CanvasObject currentCanvas;

        private final Map<String, Object> inputValues;

        private final Map<String, Object> additionalProperties;

        private ComponentId(
                String workspaceId,
                String workspaceRegion,
                String componentId,
                Admin admin,
                Context context,
                CanvasObject currentCanvas,
                Map<String, Object> inputValues,
                Map<String, Object> additionalProperties) {
            this.workspaceId = workspaceId;
            this.workspaceRegion = workspaceRegion;
            this.componentId = componentId;
            this.admin = admin;
            this.context = context;
            this.currentCanvas = currentCanvas;
            this.inputValues = inputValues;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The workspace ID of the teammate. Attribute is app_id for V1.2 and below.
         */
        @JsonProperty("workspace_id")
        public String getWorkspaceId() {
            return workspaceId;
        }

        /**
         * @return The Intercom hosted region that this app is located in.
         */
        @JsonProperty("workspace_region")
        public String getWorkspaceRegion() {
            return workspaceRegion;
        }

        /**
         * @return The id of the component clicked by the teammate to trigger the request.
         */
        @JsonProperty("component_id")
        public String getComponentId() {
            return componentId;
        }

        /**
         * @return The Intercom teammate configuring the app.
         */
        @JsonProperty("admin")
        public Admin getAdmin() {
            return admin;
        }

        /**
         * @return The context of where the app is added, where the user last visited, and information on the Messenger settings.
         */
        @JsonProperty("context")
        public Context getContext() {
            return context;
        }

        /**
         * @return The current canvas the teammate can see.
         */
        @JsonProperty("current_canvas")
        public CanvasObject getCurrentCanvas() {
            return currentCanvas;
        }

        /**
         * @return A list of key/value pairs of data, inputted by the teammate on the current canvas.
         */
        @JsonProperty("input_values")
        public Map<String, Object> getInputValues() {
            return inputValues;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ComponentId && equalTo((ComponentId) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ComponentId other) {
            return workspaceId.equals(other.workspaceId)
                    && workspaceRegion.equals(other.workspaceRegion)
                    && componentId.equals(other.componentId)
                    && admin.equals(other.admin)
                    && context.equals(other.context)
                    && currentCanvas.equals(other.currentCanvas)
                    && inputValues.equals(other.inputValues);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.workspaceId,
                    this.workspaceRegion,
                    this.componentId,
                    this.admin,
                    this.context,
                    this.currentCanvas,
                    this.inputValues);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static WorkspaceIdStage builder() {
            return new Builder();
        }

        public interface WorkspaceIdStage {
            /**
             * The workspace ID of the teammate. Attribute is app_id for V1.2 and below.
             */
            WorkspaceRegionStage workspaceId(@NotNull String workspaceId);

            Builder from(ComponentId other);
        }

        public interface WorkspaceRegionStage {
            /**
             * The Intercom hosted region that this app is located in.
             */
            ComponentIdStage workspaceRegion(@NotNull String workspaceRegion);
        }

        public interface ComponentIdStage {
            /**
             * The id of the component clicked by the teammate to trigger the request.
             */
            AdminStage componentId(@NotNull String componentId);
        }

        public interface AdminStage {
            /**
             * The Intercom teammate configuring the app.
             */
            ContextStage admin(@NotNull Admin admin);
        }

        public interface ContextStage {
            /**
             * The context of where the app is added, where the user last visited, and information on the Messenger settings.
             */
            CurrentCanvasStage context(@NotNull Context context);
        }

        public interface CurrentCanvasStage {
            /**
             * The current canvas the teammate can see.
             */
            _FinalStage currentCanvas(@NotNull CanvasObject currentCanvas);
        }

        public interface _FinalStage {
            ComponentId build();

            /**
             * <p>A list of key/value pairs of data, inputted by the teammate on the current canvas.</p>
             */
            _FinalStage inputValues(Map<String, Object> inputValues);

            _FinalStage putAllInputValues(Map<String, Object> inputValues);

            _FinalStage inputValues(String key, Object value);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder
                implements WorkspaceIdStage,
                        WorkspaceRegionStage,
                        ComponentIdStage,
                        AdminStage,
                        ContextStage,
                        CurrentCanvasStage,
                        _FinalStage {
            private String workspaceId;

            private String workspaceRegion;

            private String componentId;

            private Admin admin;

            private Context context;

            private CanvasObject currentCanvas;

            private Map<String, Object> inputValues = new LinkedHashMap<>();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(ComponentId other) {
                workspaceId(other.getWorkspaceId());
                workspaceRegion(other.getWorkspaceRegion());
                componentId(other.getComponentId());
                admin(other.getAdmin());
                context(other.getContext());
                currentCanvas(other.getCurrentCanvas());
                inputValues(other.getInputValues());
                return this;
            }

            /**
             * The workspace ID of the teammate. Attribute is app_id for V1.2 and below.<p>The workspace ID of the teammate. Attribute is app_id for V1.2 and below.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("workspace_id")
            public WorkspaceRegionStage workspaceId(@NotNull String workspaceId) {
                this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
                return this;
            }

            /**
             * The Intercom hosted region that this app is located in.<p>The Intercom hosted region that this app is located in.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("workspace_region")
            public ComponentIdStage workspaceRegion(@NotNull String workspaceRegion) {
                this.workspaceRegion = Objects.requireNonNull(workspaceRegion, "workspaceRegion must not be null");
                return this;
            }

            /**
             * The id of the component clicked by the teammate to trigger the request.<p>The id of the component clicked by the teammate to trigger the request.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("component_id")
            public AdminStage componentId(@NotNull String componentId) {
                this.componentId = Objects.requireNonNull(componentId, "componentId must not be null");
                return this;
            }

            /**
             * The Intercom teammate configuring the app.<p>The Intercom teammate configuring the app.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("admin")
            public ContextStage admin(@NotNull Admin admin) {
                this.admin = Objects.requireNonNull(admin, "admin must not be null");
                return this;
            }

            /**
             * The context of where the app is added, where the user last visited, and information on the Messenger settings.<p>The context of where the app is added, where the user last visited, and information on the Messenger settings.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("context")
            public CurrentCanvasStage context(@NotNull Context context) {
                this.context = Objects.requireNonNull(context, "context must not be null");
                return this;
            }

            /**
             * The current canvas the teammate can see.<p>The current canvas the teammate can see.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("current_canvas")
            public _FinalStage currentCanvas(@NotNull CanvasObject currentCanvas) {
                this.currentCanvas = Objects.requireNonNull(currentCanvas, "currentCanvas must not be null");
                return this;
            }

            /**
             * <p>A list of key/value pairs of data, inputted by the teammate on the current canvas.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage inputValues(String key, Object value) {
                this.inputValues.put(key, value);
                return this;
            }

            /**
             * <p>A list of key/value pairs of data, inputted by the teammate on the current canvas.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage putAllInputValues(Map<String, Object> inputValues) {
                this.inputValues.putAll(inputValues);
                return this;
            }

            /**
             * <p>A list of key/value pairs of data, inputted by the teammate on the current canvas.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "input_values", nulls = Nulls.SKIP)
            public _FinalStage inputValues(Map<String, Object> inputValues) {
                this.inputValues.clear();
                this.inputValues.putAll(inputValues);
                return this;
            }

            @java.lang.Override
            public ComponentId build() {
                return new ComponentId(
                        workspaceId,
                        workspaceRegion,
                        componentId,
                        admin,
                        context,
                        currentCanvas,
                        inputValues,
                        additionalProperties);
            }
        }
    }
}
