/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using = ConfigureResponse.Deserializer.class)
public final class ConfigureResponse {
    private final Object value;

    private final int type;

    private ConfigureResponse(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((ResultsResponse) this.value);
        } else if (this.type == 1) {
            return visitor.visit((Canvas) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConfigureResponse && equalTo((ConfigureResponse) other);
    }

    private boolean equalTo(ConfigureResponse other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static ConfigureResponse of(ResultsResponse value) {
        return new ConfigureResponse(value, 0);
    }

    public static ConfigureResponse of(Canvas value) {
        return new ConfigureResponse(value, 1);
    }

    public interface Visitor<T> {
        T visit(ResultsResponse value);

        T visit(Canvas value);
    }

    static final class Deserializer extends StdDeserializer<ConfigureResponse> {
        Deserializer() {
            super(ConfigureResponse.class);
        }

        @java.lang.Override
        public ConfigureResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, ResultsResponse.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, Canvas.class));
            } catch (IllegalArgumentException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Canvas.Builder.class)
    public static final class Canvas {
        private final CanvasObject canvas;

        private final Map<String, Object> additionalProperties;

        private Canvas(CanvasObject canvas, Map<String, Object> additionalProperties) {
            this.canvas = canvas;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The canvas object that defines the new UI to be shown. This will replace the previous canvas that was visible until the teammate interacted with your app.
         */
        @JsonProperty("canvas")
        public CanvasObject getCanvas() {
            return canvas;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Canvas && equalTo((Canvas) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Canvas other) {
            return canvas.equals(other.canvas);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.canvas);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static CanvasStage builder() {
            return new Builder();
        }

        public interface CanvasStage {
            /**
             * The canvas object that defines the new UI to be shown. This will replace the previous canvas that was visible until the teammate interacted with your app.
             */
            _FinalStage canvas(@NotNull CanvasObject canvas);

            Builder from(Canvas other);
        }

        public interface _FinalStage {
            Canvas build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements CanvasStage, _FinalStage {
            private CanvasObject canvas;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(Canvas other) {
                canvas(other.getCanvas());
                return this;
            }

            /**
             * The canvas object that defines the new UI to be shown. This will replace the previous canvas that was visible until the teammate interacted with your app.<p>The canvas object that defines the new UI to be shown. This will replace the previous canvas that was visible until the teammate interacted with your app.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("canvas")
            public _FinalStage canvas(@NotNull CanvasObject canvas) {
                this.canvas = Objects.requireNonNull(canvas, "canvas must not be null");
                return this;
            }

            @java.lang.Override
            public Canvas build() {
                return new Canvas(canvas, additionalProperties);
            }
        }
    }
}
