/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.contacts.types.Contact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContactList.Builder.class)
public final class ContactList {
    private final List<Contact> data;

    private final int totalCount;

    private final Optional<CursorPages> pages;

    private final Map<String, Object> additionalProperties;

    private ContactList(
            List<Contact> data, int totalCount, Optional<CursorPages> pages, Map<String, Object> additionalProperties) {
        this.data = data;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always list
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    /**
     * @return The list of contact objects
     */
    @JsonProperty("data")
    public List<Contact> getData() {
        return data;
    }

    /**
     * @return A count of the total number of objects.
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContactList && equalTo((ContactList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactList other) {
        return data.equals(other.data) && totalCount == other.totalCount && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.data, this.totalCount, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        /**
         * A count of the total number of objects.
         */
        _FinalStage totalCount(int totalCount);

        Builder from(ContactList other);
    }

    public interface _FinalStage {
        ContactList build();

        /**
         * <p>The list of contact objects</p>
         */
        _FinalStage data(List<Contact> data);

        _FinalStage addData(Contact data);

        _FinalStage addAllData(List<Contact> data);

        _FinalStage pages(Optional<CursorPages> pages);

        _FinalStage pages(CursorPages pages);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private Optional<CursorPages> pages = Optional.empty();

        private List<Contact> data = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContactList other) {
            data(other.getData());
            totalCount(other.getTotalCount());
            pages(other.getPages());
            return this;
        }

        /**
         * A count of the total number of objects.<p>A count of the total number of objects.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public _FinalStage pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        /**
         * <p>The list of contact objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllData(List<Contact> data) {
            this.data.addAll(data);
            return this;
        }

        /**
         * <p>The list of contact objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addData(Contact data) {
            this.data.add(data);
            return this;
        }

        /**
         * <p>The list of contact objects</p>
         */
        @java.lang.Override
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public _FinalStage data(List<Contact> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @java.lang.Override
        public ContactList build() {
            return new ContactList(data, totalCount, pages, additionalProperties);
        }
    }
}
