/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.aicontentsource.types.ContentSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContentSourcesList.Builder.class)
public final class ContentSourcesList {
    private final int totalCount;

    private final List<ContentSource> contentSources;

    private final Map<String, Object> additionalProperties;

    private ContentSourcesList(
            int totalCount, List<ContentSource> contentSources, Map<String, Object> additionalProperties) {
        this.totalCount = totalCount;
        this.contentSources = contentSources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("type")
    public String getType() {
        return "content_source.list";
    }

    /**
     * @return The total number of content sources used by AI Agent in the conversation.
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * @return The content sources used by AI Agent in the conversation.
     */
    @JsonProperty("content_sources")
    public List<ContentSource> getContentSources() {
        return contentSources;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContentSourcesList && equalTo((ContentSourcesList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSourcesList other) {
        return totalCount == other.totalCount && contentSources.equals(other.contentSources);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.totalCount, this.contentSources);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        /**
         * The total number of content sources used by AI Agent in the conversation.
         */
        _FinalStage totalCount(int totalCount);

        Builder from(ContentSourcesList other);
    }

    public interface _FinalStage {
        ContentSourcesList build();

        /**
         * <p>The content sources used by AI Agent in the conversation.</p>
         */
        _FinalStage contentSources(List<ContentSource> contentSources);

        _FinalStage addContentSources(ContentSource contentSources);

        _FinalStage addAllContentSources(List<ContentSource> contentSources);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private List<ContentSource> contentSources = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContentSourcesList other) {
            totalCount(other.getTotalCount());
            contentSources(other.getContentSources());
            return this;
        }

        /**
         * The total number of content sources used by AI Agent in the conversation.<p>The total number of content sources used by AI Agent in the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * <p>The content sources used by AI Agent in the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllContentSources(List<ContentSource> contentSources) {
            this.contentSources.addAll(contentSources);
            return this;
        }

        /**
         * <p>The content sources used by AI Agent in the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addContentSources(ContentSource contentSources) {
            this.contentSources.add(contentSources);
            return this;
        }

        /**
         * <p>The content sources used by AI Agent in the conversation.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "content_sources", nulls = Nulls.SKIP)
        public _FinalStage contentSources(List<ContentSource> contentSources) {
            this.contentSources.clear();
            this.contentSources.addAll(contentSources);
            return this;
        }

        @java.lang.Override
        public ContentSourcesList build() {
            return new ContentSourcesList(totalCount, contentSources, additionalProperties);
        }
    }
}
