/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationPartAuthor.Builder.class)
public final class ConversationPartAuthor {
    private final String type;

    private final String id;

    private final String name;

    private final String email;

    private final Map<String, Object> additionalProperties;

    private ConversationPartAuthor(
            String type, String id, String name, String email, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the author
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The id of the author
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the author
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The email of the author
     */
    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationPartAuthor && equalTo((ConversationPartAuthor) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPartAuthor other) {
        return type.equals(other.type) && id.equals(other.id) && name.equals(other.name) && email.equals(other.email);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * The type of the author
         */
        IdStage type(@NotNull String type);

        Builder from(ConversationPartAuthor other);
    }

    public interface IdStage {
        /**
         * The id of the author
         */
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        /**
         * The name of the author
         */
        EmailStage name(@NotNull String name);
    }

    public interface EmailStage {
        /**
         * The email of the author
         */
        _FinalStage email(@NotNull String email);
    }

    public interface _FinalStage {
        ConversationPartAuthor build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, NameStage, EmailStage, _FinalStage {
        private String type;

        private String id;

        private String name;

        private String email;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationPartAuthor other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            return this;
        }

        /**
         * The type of the author<p>The type of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * The id of the author<p>The id of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The name of the author<p>The name of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public EmailStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The email of the author<p>The email of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("email")
        public _FinalStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @java.lang.Override
        public ConversationPartAuthor build() {
            return new ConversationPartAuthor(type, id, name, email, additionalProperties);
        }
    }
}
