/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataEventSummary.Builder.class)
public final class DataEventSummary {
    private final String email;

    private final String intercomUserId;

    private final String userId;

    private final List<DataEventSummaryItem> events;

    private final Map<String, Object> additionalProperties;

    private DataEventSummary(
            String email,
            String intercomUserId,
            String userId,
            List<DataEventSummaryItem> events,
            Map<String, Object> additionalProperties) {
        this.email = email;
        this.intercomUserId = intercomUserId;
        this.userId = userId;
        this.events = events;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public String getType() {
        return "event.summary";
    }

    /**
     * @return The email address of the user
     */
    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    /**
     * @return The Intercom user ID of the user
     */
    @JsonProperty("intercom_user_id")
    public String getIntercomUserId() {
        return intercomUserId;
    }

    /**
     * @return The user ID of the user
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    /**
     * @return A summary of data events
     */
    @JsonProperty("events")
    public List<DataEventSummaryItem> getEvents() {
        return events;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataEventSummary && equalTo((DataEventSummary) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventSummary other) {
        return email.equals(other.email)
                && intercomUserId.equals(other.intercomUserId)
                && userId.equals(other.userId)
                && events.equals(other.events);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.email, this.intercomUserId, this.userId, this.events);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EmailStage builder() {
        return new Builder();
    }

    public interface EmailStage {
        /**
         * The email address of the user
         */
        IntercomUserIdStage email(@NotNull String email);

        Builder from(DataEventSummary other);
    }

    public interface IntercomUserIdStage {
        /**
         * The Intercom user ID of the user
         */
        UserIdStage intercomUserId(@NotNull String intercomUserId);
    }

    public interface UserIdStage {
        /**
         * The user ID of the user
         */
        _FinalStage userId(@NotNull String userId);
    }

    public interface _FinalStage {
        DataEventSummary build();

        /**
         * <p>A summary of data events</p>
         */
        _FinalStage events(List<DataEventSummaryItem> events);

        _FinalStage addEvents(DataEventSummaryItem events);

        _FinalStage addAllEvents(List<DataEventSummaryItem> events);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements EmailStage, IntercomUserIdStage, UserIdStage, _FinalStage {
        private String email;

        private String intercomUserId;

        private String userId;

        private List<DataEventSummaryItem> events = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DataEventSummary other) {
            email(other.getEmail());
            intercomUserId(other.getIntercomUserId());
            userId(other.getUserId());
            events(other.getEvents());
            return this;
        }

        /**
         * The email address of the user<p>The email address of the user</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("email")
        public IntercomUserIdStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        /**
         * The Intercom user ID of the user<p>The Intercom user ID of the user</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("intercom_user_id")
        public UserIdStage intercomUserId(@NotNull String intercomUserId) {
            this.intercomUserId = Objects.requireNonNull(intercomUserId, "intercomUserId must not be null");
            return this;
        }

        /**
         * The user ID of the user<p>The user ID of the user</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        /**
         * <p>A summary of data events</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllEvents(List<DataEventSummaryItem> events) {
            this.events.addAll(events);
            return this;
        }

        /**
         * <p>A summary of data events</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addEvents(DataEventSummaryItem events) {
            this.events.add(events);
            return this;
        }

        /**
         * <p>A summary of data events</p>
         */
        @java.lang.Override
        @JsonSetter(value = "events", nulls = Nulls.SKIP)
        public _FinalStage events(List<DataEventSummaryItem> events) {
            this.events.clear();
            this.events.addAll(events);
            return this;
        }

        @java.lang.Override
        public DataEventSummary build() {
            return new DataEventSummary(email, intercomUserId, userId, events, additionalProperties);
        }
    }
}
