/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GroupContent.Builder.class)
public final class GroupContent {
    private final String name;

    private final String description;

    private final Map<String, Object> additionalProperties;

    private GroupContent(String name, String description, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>group_content</code> .
     */
    @JsonProperty("type")
    public String getType() {
        return "group_content";
    }

    /**
     * @return The name of the collection or section.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The description of the collection. Only available for collections.
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GroupContent && equalTo((GroupContent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GroupContent other) {
        return name.equals(other.name) && description.equals(other.description);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * The name of the collection or section.
         */
        DescriptionStage name(@NotNull String name);

        Builder from(GroupContent other);
    }

    public interface DescriptionStage {
        /**
         * The description of the collection. Only available for collections.
         */
        _FinalStage description(@NotNull String description);
    }

    public interface _FinalStage {
        GroupContent build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, DescriptionStage, _FinalStage {
        private String name;

        private String description;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(GroupContent other) {
            name(other.getName());
            description(other.getDescription());
            return this;
        }

        /**
         * The name of the collection or section.<p>The name of the collection or section.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The description of the collection. Only available for collections.<p>The description of the collection. Only available for collections.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("description")
        public _FinalStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        public GroupContent build() {
            return new GroupContent(name, description, additionalProperties);
        }
    }
}
