/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListComponent.Builder.class)
public final class ListComponent {
    private final List<ItemsItem> items;

    private final Optional<Boolean> disabled;

    private final Map<String, Object> additionalProperties;

    private ListComponent(List<ItemsItem> items, Optional<Boolean> disabled, Map<String, Object> additionalProperties) {
        this.items = items;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The items that will be rendered in the list.
     */
    @JsonProperty("items")
    public List<ItemsItem> getItems() {
        return items;
    }

    /**
     * @return Styles all list items and prevents the action. Default is <code>false</code>.
     */
    @JsonProperty("disabled")
    public Optional<Boolean> getDisabled() {
        return disabled;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListComponent && equalTo((ListComponent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListComponent other) {
        return items.equals(other.items) && disabled.equals(other.disabled);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.items, this.disabled);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<ItemsItem> items = new ArrayList<>();

        private Optional<Boolean> disabled = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListComponent other) {
            items(other.getItems());
            disabled(other.getDisabled());
            return this;
        }

        /**
         * <p>The items that will be rendered in the list.</p>
         */
        @JsonSetter(value = "items", nulls = Nulls.SKIP)
        public Builder items(List<ItemsItem> items) {
            this.items.clear();
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(ItemsItem items) {
            this.items.add(items);
            return this;
        }

        public Builder addAllItems(List<ItemsItem> items) {
            this.items.addAll(items);
            return this;
        }

        /**
         * <p>Styles all list items and prevents the action. Default is <code>false</code>.</p>
         */
        @JsonSetter(value = "disabled", nulls = Nulls.SKIP)
        public Builder disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        public ListComponent build() {
            return new ListComponent(items, disabled, additionalProperties);
        }
    }

    @JsonDeserialize(using = ItemsItem.Deserializer.class)
    public static final class ItemsItem {
        private final Object value;

        private final int type;

        private ItemsItem(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((ListItemWithImage) this.value);
            } else if (this.type == 1) {
                return visitor.visit((ListItemWithoutImage) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ItemsItem && equalTo((ItemsItem) other);
        }

        private boolean equalTo(ItemsItem other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static ItemsItem of(ListItemWithImage value) {
            return new ItemsItem(value, 0);
        }

        public static ItemsItem of(ListItemWithoutImage value) {
            return new ItemsItem(value, 1);
        }

        public interface Visitor<T> {
            T visit(ListItemWithImage value);

            T visit(ListItemWithoutImage value);
        }

        static final class Deserializer extends StdDeserializer<ItemsItem> {
            Deserializer() {
                super(ItemsItem.class);
            }

            @java.lang.Override
            public ItemsItem deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, ListItemWithImage.class));
                } catch (IllegalArgumentException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, ListItemWithoutImage.class));
                } catch (IllegalArgumentException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }
}
