/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListItemWithoutImage.Builder.class)
public final class ListItemWithoutImage implements IListItem {
    private final String id;

    private final String title;

    private final Optional<String> subtitle;

    private final Optional<String> tertiaryText;

    private final Optional<Boolean> roundedImage;

    private final Optional<Boolean> disabled;

    private final Optional<ActionComponent> action;

    private final Optional<String> image;

    private final Optional<Integer> imageWidth;

    private final Optional<Integer> imageHeight;

    private final Map<String, Object> additionalProperties;

    private ListItemWithoutImage(
            String id,
            String title,
            Optional<String> subtitle,
            Optional<String> tertiaryText,
            Optional<Boolean> roundedImage,
            Optional<Boolean> disabled,
            Optional<ActionComponent> action,
            Optional<String> image,
            Optional<Integer> imageWidth,
            Optional<Integer> imageHeight,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.title = title;
        this.subtitle = subtitle;
        this.tertiaryText = tertiaryText;
        this.roundedImage = roundedImage;
        this.disabled = disabled;
        this.action = action;
        this.image = image;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of component you are rendering.
     */
    @JsonProperty("type")
    public String getType() {
        return "item";
    }

    /**
     * @return A unique identifier for the item.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The text shown as the title for the item.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The text shown underneath the item's title.
     */
    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return subtitle;
    }

    /**
     * @return The text shown next to the subtitle, separates by a bullet.
     */
    @JsonProperty("tertiary_text")
    public Optional<String> getTertiaryText() {
        return tertiaryText;
    }

    /**
     * @return Rounds the corners of the image. Default is <code>false</code>.
     */
    @JsonProperty("rounded_image")
    public Optional<Boolean> getRoundedImage() {
        return roundedImage;
    }

    /**
     * @return Styles all list items and prevents the action. Default is <code>false</code>.
     */
    @JsonProperty("disabled")
    public Optional<Boolean> getDisabled() {
        return disabled;
    }

    /**
     * @return This can be a Submit Action, URL Action, or Sheets Action.
     */
    @JsonProperty("action")
    public Optional<ActionComponent> getAction() {
        return action;
    }

    /**
     * @return An image that will be displayed to the left of the item.
     */
    @JsonProperty("image")
    public Optional<String> getImage() {
        return image;
    }

    /**
     * @return The exact width of the image in pixels.
     */
    @JsonProperty("image_width")
    public Optional<Integer> getImageWidth() {
        return imageWidth;
    }

    /**
     * @return The exact height of the image in pixels.
     */
    @JsonProperty("image_height")
    public Optional<Integer> getImageHeight() {
        return imageHeight;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListItemWithoutImage && equalTo((ListItemWithoutImage) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListItemWithoutImage other) {
        return id.equals(other.id)
                && title.equals(other.title)
                && subtitle.equals(other.subtitle)
                && tertiaryText.equals(other.tertiaryText)
                && roundedImage.equals(other.roundedImage)
                && disabled.equals(other.disabled)
                && action.equals(other.action)
                && image.equals(other.image)
                && imageWidth.equals(other.imageWidth)
                && imageHeight.equals(other.imageHeight);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.title,
                this.subtitle,
                this.tertiaryText,
                this.roundedImage,
                this.disabled,
                this.action,
                this.image,
                this.imageWidth,
                this.imageHeight);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * A unique identifier for the item.
         */
        TitleStage id(@NotNull String id);

        Builder from(ListItemWithoutImage other);
    }

    public interface TitleStage {
        /**
         * The text shown as the title for the item.
         */
        _FinalStage title(@NotNull String title);
    }

    public interface _FinalStage {
        ListItemWithoutImage build();

        /**
         * <p>The text shown underneath the item's title.</p>
         */
        _FinalStage subtitle(Optional<String> subtitle);

        _FinalStage subtitle(String subtitle);

        /**
         * <p>The text shown next to the subtitle, separates by a bullet.</p>
         */
        _FinalStage tertiaryText(Optional<String> tertiaryText);

        _FinalStage tertiaryText(String tertiaryText);

        /**
         * <p>Rounds the corners of the image. Default is <code>false</code>.</p>
         */
        _FinalStage roundedImage(Optional<Boolean> roundedImage);

        _FinalStage roundedImage(Boolean roundedImage);

        /**
         * <p>Styles all list items and prevents the action. Default is <code>false</code>.</p>
         */
        _FinalStage disabled(Optional<Boolean> disabled);

        _FinalStage disabled(Boolean disabled);

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         */
        _FinalStage action(Optional<ActionComponent> action);

        _FinalStage action(ActionComponent action);

        /**
         * <p>An image that will be displayed to the left of the item.</p>
         */
        _FinalStage image(Optional<String> image);

        _FinalStage image(String image);

        /**
         * <p>The exact width of the image in pixels.</p>
         */
        _FinalStage imageWidth(Optional<Integer> imageWidth);

        _FinalStage imageWidth(Integer imageWidth);

        /**
         * <p>The exact height of the image in pixels.</p>
         */
        _FinalStage imageHeight(Optional<Integer> imageHeight);

        _FinalStage imageHeight(Integer imageHeight);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, TitleStage, _FinalStage {
        private String id;

        private String title;

        private Optional<Integer> imageHeight = Optional.empty();

        private Optional<Integer> imageWidth = Optional.empty();

        private Optional<String> image = Optional.empty();

        private Optional<ActionComponent> action = Optional.empty();

        private Optional<Boolean> disabled = Optional.empty();

        private Optional<Boolean> roundedImage = Optional.empty();

        private Optional<String> tertiaryText = Optional.empty();

        private Optional<String> subtitle = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ListItemWithoutImage other) {
            id(other.getId());
            title(other.getTitle());
            subtitle(other.getSubtitle());
            tertiaryText(other.getTertiaryText());
            roundedImage(other.getRoundedImage());
            disabled(other.getDisabled());
            action(other.getAction());
            image(other.getImage());
            imageWidth(other.getImageWidth());
            imageHeight(other.getImageHeight());
            return this;
        }

        /**
         * A unique identifier for the item.<p>A unique identifier for the item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public TitleStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The text shown as the title for the item.<p>The text shown as the title for the item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public _FinalStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * <p>The exact height of the image in pixels.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage imageHeight(Integer imageHeight) {
            this.imageHeight = Optional.ofNullable(imageHeight);
            return this;
        }

        /**
         * <p>The exact height of the image in pixels.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "image_height", nulls = Nulls.SKIP)
        public _FinalStage imageHeight(Optional<Integer> imageHeight) {
            this.imageHeight = imageHeight;
            return this;
        }

        /**
         * <p>The exact width of the image in pixels.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage imageWidth(Integer imageWidth) {
            this.imageWidth = Optional.ofNullable(imageWidth);
            return this;
        }

        /**
         * <p>The exact width of the image in pixels.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "image_width", nulls = Nulls.SKIP)
        public _FinalStage imageWidth(Optional<Integer> imageWidth) {
            this.imageWidth = imageWidth;
            return this;
        }

        /**
         * <p>An image that will be displayed to the left of the item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage image(String image) {
            this.image = Optional.ofNullable(image);
            return this;
        }

        /**
         * <p>An image that will be displayed to the left of the item.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "image", nulls = Nulls.SKIP)
        public _FinalStage image(Optional<String> image) {
            this.image = image;
            return this;
        }

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage action(ActionComponent action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "action", nulls = Nulls.SKIP)
        public _FinalStage action(Optional<ActionComponent> action) {
            this.action = action;
            return this;
        }

        /**
         * <p>Styles all list items and prevents the action. Default is <code>false</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        /**
         * <p>Styles all list items and prevents the action. Default is <code>false</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "disabled", nulls = Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        /**
         * <p>Rounds the corners of the image. Default is <code>false</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage roundedImage(Boolean roundedImage) {
            this.roundedImage = Optional.ofNullable(roundedImage);
            return this;
        }

        /**
         * <p>Rounds the corners of the image. Default is <code>false</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "rounded_image", nulls = Nulls.SKIP)
        public _FinalStage roundedImage(Optional<Boolean> roundedImage) {
            this.roundedImage = roundedImage;
            return this;
        }

        /**
         * <p>The text shown next to the subtitle, separates by a bullet.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage tertiaryText(String tertiaryText) {
            this.tertiaryText = Optional.ofNullable(tertiaryText);
            return this;
        }

        /**
         * <p>The text shown next to the subtitle, separates by a bullet.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "tertiary_text", nulls = Nulls.SKIP)
        public _FinalStage tertiaryText(Optional<String> tertiaryText) {
            this.tertiaryText = tertiaryText;
            return this;
        }

        /**
         * <p>The text shown underneath the item's title.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage subtitle(String subtitle) {
            this.subtitle = Optional.ofNullable(subtitle);
            return this;
        }

        /**
         * <p>The text shown underneath the item's title.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "subtitle", nulls = Nulls.SKIP)
        public _FinalStage subtitle(Optional<String> subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @java.lang.Override
        public ListItemWithoutImage build() {
            return new ListItemWithoutImage(
                    id,
                    title,
                    subtitle,
                    tertiaryText,
                    roundedImage,
                    disabled,
                    action,
                    image,
                    imageWidth,
                    imageHeight,
                    additionalProperties);
        }
    }
}
