/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PartAttachment.Builder.class)
public final class PartAttachment {
    private final String type;

    private final String name;

    private final String url;

    private final String contentType;

    private final int filesize;

    private final int width;

    private final int height;

    private final Map<String, Object> additionalProperties;

    private PartAttachment(
            String type,
            String name,
            String url,
            String contentType,
            int filesize,
            int width,
            int height,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.contentType = contentType;
        this.filesize = filesize;
        this.width = width;
        this.height = height;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of attachment
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The name of the attachment
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The URL of the attachment
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * @return The content type of the attachment
     */
    @JsonProperty("content_type")
    public String getContentType() {
        return contentType;
    }

    /**
     * @return The size of the attachment
     */
    @JsonProperty("filesize")
    public int getFilesize() {
        return filesize;
    }

    /**
     * @return The width of the attachment
     */
    @JsonProperty("width")
    public int getWidth() {
        return width;
    }

    /**
     * @return The height of the attachment
     */
    @JsonProperty("height")
    public int getHeight() {
        return height;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PartAttachment && equalTo((PartAttachment) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PartAttachment other) {
        return type.equals(other.type)
                && name.equals(other.name)
                && url.equals(other.url)
                && contentType.equals(other.contentType)
                && filesize == other.filesize
                && width == other.width
                && height == other.height;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.name, this.url, this.contentType, this.filesize, this.width, this.height);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * The type of attachment
         */
        NameStage type(@NotNull String type);

        Builder from(PartAttachment other);
    }

    public interface NameStage {
        /**
         * The name of the attachment
         */
        UrlStage name(@NotNull String name);
    }

    public interface UrlStage {
        /**
         * The URL of the attachment
         */
        ContentTypeStage url(@NotNull String url);
    }

    public interface ContentTypeStage {
        /**
         * The content type of the attachment
         */
        FilesizeStage contentType(@NotNull String contentType);
    }

    public interface FilesizeStage {
        /**
         * The size of the attachment
         */
        WidthStage filesize(int filesize);
    }

    public interface WidthStage {
        /**
         * The width of the attachment
         */
        HeightStage width(int width);
    }

    public interface HeightStage {
        /**
         * The height of the attachment
         */
        _FinalStage height(int height);
    }

    public interface _FinalStage {
        PartAttachment build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements TypeStage,
                    NameStage,
                    UrlStage,
                    ContentTypeStage,
                    FilesizeStage,
                    WidthStage,
                    HeightStage,
                    _FinalStage {
        private String type;

        private String name;

        private String url;

        private String contentType;

        private int filesize;

        private int width;

        private int height;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PartAttachment other) {
            type(other.getType());
            name(other.getName());
            url(other.getUrl());
            contentType(other.getContentType());
            filesize(other.getFilesize());
            width(other.getWidth());
            height(other.getHeight());
            return this;
        }

        /**
         * The type of attachment<p>The type of attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public NameStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * The name of the attachment<p>The name of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public UrlStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The URL of the attachment<p>The URL of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public ContentTypeStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        /**
         * The content type of the attachment<p>The content type of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("content_type")
        public FilesizeStage contentType(@NotNull String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
            return this;
        }

        /**
         * The size of the attachment<p>The size of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("filesize")
        public WidthStage filesize(int filesize) {
            this.filesize = filesize;
            return this;
        }

        /**
         * The width of the attachment<p>The width of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("width")
        public HeightStage width(int width) {
            this.width = width;
            return this;
        }

        /**
         * The height of the attachment<p>The height of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("height")
        public _FinalStage height(int height) {
            this.height = height;
            return this;
        }

        @java.lang.Override
        public PartAttachment build() {
            return new PartAttachment(type, name, url, contentType, filesize, width, height, additionalProperties);
        }
    }
}
