/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SpacerComponent.Builder.class)
public final class SpacerComponent {
    private final Optional<String> id;

    private final Optional<Size> size;

    private final Map<String, Object> additionalProperties;

    private SpacerComponent(Optional<String> id, Optional<Size> size, Map<String, Object> additionalProperties) {
        this.id = id;
        this.size = size;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return A unique identifier for the component.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The amount of space between components. Default is <code>s</code>.
     */
    @JsonProperty("size")
    public Optional<Size> getSize() {
        return size;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SpacerComponent && equalTo((SpacerComponent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SpacerComponent other) {
        return id.equals(other.id) && size.equals(other.size);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.size);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();

        private Optional<Size> size = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SpacerComponent other) {
            id(other.getId());
            size(other.getSize());
            return this;
        }

        /**
         * <p>A unique identifier for the component.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The amount of space between components. Default is <code>s</code>.</p>
         */
        @JsonSetter(value = "size", nulls = Nulls.SKIP)
        public Builder size(Optional<Size> size) {
            this.size = size;
            return this;
        }

        public Builder size(Size size) {
            this.size = Optional.ofNullable(size);
            return this;
        }

        public SpacerComponent build() {
            return new SpacerComponent(id, size, additionalProperties);
        }
    }

    public static final class Size {
        public static final Size XS = new Size(Value.XS, "xs");

        public static final Size S = new Size(Value.S, "s");

        public static final Size L = new Size(Value.L, "l");

        public static final Size XL = new Size(Value.XL, "xl");

        public static final Size M = new Size(Value.M, "m");

        private final Value value;

        private final String string;

        Size(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Size && this.string.equals(((Size) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case XS:
                    return visitor.visitXs();
                case S:
                    return visitor.visitS();
                case L:
                    return visitor.visitL();
                case XL:
                    return visitor.visitXl();
                case M:
                    return visitor.visitM();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Size valueOf(String value) {
            switch (value) {
                case "xs":
                    return XS;
                case "s":
                    return S;
                case "l":
                    return L;
                case "xl":
                    return XL;
                case "m":
                    return M;
                default:
                    return new Size(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            XS,

            S,

            M,

            L,

            XL,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitXs();

            T visitS();

            T visitM();

            T visitL();

            T visitXl();

            T visitUnknown(String unknownType);
        }
    }
}
