/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = StartingAfterPaging.Builder.class)
public final class StartingAfterPaging {
    private final int perPage;

    private final Optional<String> startingAfter;

    private final Map<String, Object> additionalProperties;

    private StartingAfterPaging(int perPage, Optional<String> startingAfter, Map<String, Object> additionalProperties) {
        this.perPage = perPage;
        this.startingAfter = startingAfter;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The number of results to fetch per page.
     */
    @JsonProperty("per_page")
    public int getPerPage() {
        return perPage;
    }

    /**
     * @return The cursor to use in the next request to get the next page of results.
     */
    @JsonProperty("starting_after")
    public Optional<String> getStartingAfter() {
        return startingAfter;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof StartingAfterPaging && equalTo((StartingAfterPaging) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StartingAfterPaging other) {
        return perPage == other.perPage && startingAfter.equals(other.startingAfter);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.perPage, this.startingAfter);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PerPageStage builder() {
        return new Builder();
    }

    public interface PerPageStage {
        /**
         * The number of results to fetch per page.
         */
        _FinalStage perPage(int perPage);

        Builder from(StartingAfterPaging other);
    }

    public interface _FinalStage {
        StartingAfterPaging build();

        /**
         * <p>The cursor to use in the next request to get the next page of results.</p>
         */
        _FinalStage startingAfter(Optional<String> startingAfter);

        _FinalStage startingAfter(String startingAfter);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PerPageStage, _FinalStage {
        private int perPage;

        private Optional<String> startingAfter = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(StartingAfterPaging other) {
            perPage(other.getPerPage());
            startingAfter(other.getStartingAfter());
            return this;
        }

        /**
         * The number of results to fetch per page.<p>The number of results to fetch per page.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("per_page")
        public _FinalStage perPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        /**
         * <p>The cursor to use in the next request to get the next page of results.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage startingAfter(String startingAfter) {
            this.startingAfter = Optional.ofNullable(startingAfter);
            return this;
        }

        /**
         * <p>The cursor to use in the next request to get the next page of results.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "starting_after", nulls = Nulls.SKIP)
        public _FinalStage startingAfter(Optional<String> startingAfter) {
            this.startingAfter = startingAfter;
            return this;
        }

        @java.lang.Override
        public StartingAfterPaging build() {
            return new StartingAfterPaging(perPage, startingAfter, additionalProperties);
        }
    }
}
