/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.subscriptiontypes.types.SubscriptionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SubscriptionTypeList.Builder.class)
public final class SubscriptionTypeList {
    private final List<SubscriptionType> data;

    private final Map<String, Object> additionalProperties;

    private SubscriptionTypeList(List<SubscriptionType> data, Map<String, Object> additionalProperties) {
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    /**
     * @return A list of subscription type objects associated with the workspace .
     */
    @JsonProperty("data")
    public List<SubscriptionType> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SubscriptionTypeList && equalTo((SubscriptionTypeList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionTypeList other) {
        return data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<SubscriptionType> data = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SubscriptionTypeList other) {
            data(other.getData());
            return this;
        }

        /**
         * <p>A list of subscription type objects associated with the workspace .</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(List<SubscriptionType> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        public Builder addData(SubscriptionType data) {
            this.data.add(data);
            return this;
        }

        public Builder addAllData(List<SubscriptionType> data) {
            this.data.addAll(data);
            return this;
        }

        public SubscriptionTypeList build() {
            return new SubscriptionTypeList(data, additionalProperties);
        }
    }
}
