/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.teams.types.Team;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TeamList.Builder.class)
public final class TeamList {
    private final List<Team> teams;

    private final Map<String, Object> additionalProperties;

    private TeamList(List<Team> teams, Map<String, Object> additionalProperties) {
        this.teams = teams;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public String getType() {
        return "team.list";
    }

    /**
     * @return A list of team objects
     */
    @JsonProperty("teams")
    public List<Team> getTeams() {
        return teams;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TeamList && equalTo((TeamList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamList other) {
        return teams.equals(other.teams);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.teams);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<Team> teams = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TeamList other) {
            teams(other.getTeams());
            return this;
        }

        /**
         * <p>A list of team objects</p>
         */
        @JsonSetter(value = "teams", nulls = Nulls.SKIP)
        public Builder teams(List<Team> teams) {
            this.teams.clear();
            this.teams.addAll(teams);
            return this;
        }

        public Builder addTeams(Team teams) {
            this.teams.add(teams);
            return this;
        }

        public Builder addAllTeams(List<Team> teams) {
            this.teams.addAll(teams);
            return this;
        }

        public TeamList build() {
            return new TeamList(teams, additionalProperties);
        }
    }
}
