/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.TicketPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketParts.Builder.class)
public final class TicketParts {
    private final List<TicketPart> ticketParts;

    private final int totalCount;

    private final Map<String, Object> additionalProperties;

    private TicketParts(List<TicketPart> ticketParts, int totalCount, Map<String, Object> additionalProperties) {
        this.ticketParts = ticketParts;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return
     */
    @JsonProperty("type")
    public String getType() {
        return "ticket_part.list";
    }

    /**
     * @return A list of Ticket Part objects for each ticket. There is a limit of 500 parts.
     */
    @JsonProperty("ticket_parts")
    public List<TicketPart> getTicketParts() {
        return ticketParts;
    }

    /**
     * @return
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketParts && equalTo((TicketParts) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketParts other) {
        return ticketParts.equals(other.ticketParts) && totalCount == other.totalCount;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.ticketParts, this.totalCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        _FinalStage totalCount(int totalCount);

        Builder from(TicketParts other);
    }

    public interface _FinalStage {
        TicketParts build();

        /**
         * <p>A list of Ticket Part objects for each ticket. There is a limit of 500 parts.</p>
         */
        _FinalStage ticketParts(List<TicketPart> ticketParts);

        _FinalStage addTicketParts(TicketPart ticketParts);

        _FinalStage addAllTicketParts(List<TicketPart> ticketParts);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private List<TicketPart> ticketParts = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TicketParts other) {
            ticketParts(other.getTicketParts());
            totalCount(other.getTotalCount());
            return this;
        }

        /**
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * <p>A list of Ticket Part objects for each ticket. There is a limit of 500 parts.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllTicketParts(List<TicketPart> ticketParts) {
            this.ticketParts.addAll(ticketParts);
            return this;
        }

        /**
         * <p>A list of Ticket Part objects for each ticket. There is a limit of 500 parts.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addTicketParts(TicketPart ticketParts) {
            this.ticketParts.add(ticketParts);
            return this;
        }

        /**
         * <p>A list of Ticket Part objects for each ticket. There is a limit of 500 parts.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ticket_parts", nulls = Nulls.SKIP)
        public _FinalStage ticketParts(List<TicketPart> ticketParts) {
            this.ticketParts.clear();
            this.ticketParts.addAll(ticketParts);
            return this;
        }

        @java.lang.Override
        public TicketParts build() {
            return new TicketParts(ticketParts, totalCount, additionalProperties);
        }
    }
}
