/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = VisitorDeletedObject.Builder.class)
public final class VisitorDeletedObject {
    private final String id;

    private final String userId;

    private final Map<String, Object> additionalProperties;

    private VisitorDeletedObject(String id, String userId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the visitor which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The type of object which was deleted
     */
    @JsonProperty("type")
    public String getType() {
        return "visitor";
    }

    /**
     * @return Automatically generated identifier for the Visitor.
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof VisitorDeletedObject && equalTo((VisitorDeletedObject) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(VisitorDeletedObject other) {
        return id.equals(other.id) && userId.equals(other.userId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.userId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the visitor which is given by Intercom.
         */
        UserIdStage id(@NotNull String id);

        Builder from(VisitorDeletedObject other);
    }

    public interface UserIdStage {
        /**
         * Automatically generated identifier for the Visitor.
         */
        _FinalStage userId(@NotNull String userId);
    }

    public interface _FinalStage {
        VisitorDeletedObject build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, UserIdStage, _FinalStage {
        private String id;

        private String userId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(VisitorDeletedObject other) {
            id(other.getId());
            userId(other.getUserId());
            return this;
        }

        /**
         * The unique identifier for the visitor which is given by Intercom.<p>The unique identifier for the visitor which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public UserIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * Automatically generated identifier for the Visitor.<p>Automatically generated identifier for the Visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @java.lang.Override
        public VisitorDeletedObject build() {
            return new VisitorDeletedObject(id, userId, additionalProperties);
        }
    }
}
