/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.core.pagination;

import com.intercom.api.core.pagination.SyncPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SyncPagingIterable<T>
extends SyncPage<T>
implements Iterable<T> {
    public SyncPagingIterable(boolean hasNext, List<T> items, Supplier<? extends SyncPage<T>> getNext) {
        super(hasNext, items, getNext);
    }

    public SyncPagingIterable(boolean hasNext, Optional<List<T>> items, Supplier<? extends SyncPage<T>> getNext) {
        super(hasNext, items.orElse(new ArrayList()), getNext);
    }

    public Stream<T> streamItems() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<T> itemsIterator;
            private SyncPage<T> currentPage;
            {
                this.itemsIterator = SyncPagingIterable.this.getItems().iterator();
                this.currentPage = SyncPagingIterable.this;
            }

            @Override
            public boolean hasNext() {
                if (this.itemsIterator.hasNext()) {
                    return true;
                }
                if (this.currentPage.hasNext()) {
                    this.advancePage();
                    return this.itemsIterator.hasNext();
                }
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.itemsIterator.next();
            }

            private void advancePage() {
                this.currentPage = this.currentPage.nextPage();
                this.itemsIterator = this.currentPage.getItems().iterator();
            }
        };
    }
}

