/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.aicontentsource.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentSource {
    private final String url;
    private final String title;
    private final String locale;
    private final Map<String, Object> additionalProperties;

    private ContentSource(String url, String title, String locale, Map<String, Object> additionalProperties) {
        this.url = url;
        this.title = title;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="content_type")
    public String getContentType() {
        return "custom_answer";
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentSource && this.equalTo((ContentSource)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSource other) {
        return this.url.equals(other.url) && this.title.equals(other.title) && this.locale.equals(other.locale);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.title, this.locale);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UrlStage,
    TitleStage,
    LocaleStage,
    _FinalStage {
        private String url;
        private String title;
        private String locale;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContentSource other) {
            this.url(other.getUrl());
            this.title(other.getTitle());
            this.locale(other.getLocale());
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public TitleStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public LocaleStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="locale")
        public _FinalStage locale(@NotNull String locale) {
            this.locale = Objects.requireNonNull(locale, "locale must not be null");
            return this;
        }

        @Override
        public ContentSource build() {
            return new ContentSource(this.url, this.title, this.locale, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContentSource build();
    }

    public static interface LocaleStage {
        public _FinalStage locale(@NotNull String var1);
    }

    public static interface TitleStage {
        public LocaleStage title(@NotNull String var1);
    }

    public static interface UrlStage {
        public TitleStage url(@NotNull String var1);

        public Builder from(ContentSource var1);
    }
}

