/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.articles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.articles.types.IArticleListItem;
import com.intercom.api.types.ArticleTranslatedContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ArticleListItem
implements IArticleListItem {
    private final Optional<String> type;
    private final String id;
    private final String workspaceId;
    private final String title;
    private final Optional<String> description;
    private final Optional<String> body;
    private final int authorId;
    private final State state;
    private final int createdAt;
    private final int updatedAt;
    private final Optional<String> url;
    private final Optional<Integer> parentId;
    private final Optional<List<Integer>> parentIds;
    private final Optional<String> parentType;
    private final String defaultLocale;
    private final ArticleTranslatedContent translatedContent;
    private final Map<String, Object> additionalProperties;

    private ArticleListItem(Optional<String> type, String id, String workspaceId, String title, Optional<String> description, Optional<String> body, int authorId, State state, int createdAt, int updatedAt, Optional<String> url, Optional<Integer> parentId, Optional<List<Integer>> parentIds, Optional<String> parentType, String defaultLocale, ArticleTranslatedContent translatedContent, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.workspaceId = workspaceId;
        this.title = title;
        this.description = description;
        this.body = body;
        this.authorId = authorId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.parentId = parentId;
        this.parentIds = parentIds;
        this.parentType = parentType;
        this.defaultLocale = defaultLocale;
        this.translatedContent = translatedContent;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @Override
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="author_id")
    public int getAuthorId() {
        return this.authorId;
    }

    @JsonProperty(value="state")
    public State getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @Override
    @JsonProperty(value="parent_id")
    public Optional<Integer> getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="parent_ids")
    public Optional<List<Integer>> getParentIds() {
        return this.parentIds;
    }

    @Override
    @JsonProperty(value="parent_type")
    public Optional<String> getParentType() {
        return this.parentType;
    }

    @Override
    @JsonProperty(value="default_locale")
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    @JsonProperty(value="translated_content")
    public ArticleTranslatedContent getTranslatedContent() {
        return this.translatedContent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ArticleListItem && this.equalTo((ArticleListItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleListItem other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.title.equals(other.title) && this.description.equals(other.description) && this.body.equals(other.body) && this.authorId == other.authorId && this.state.equals(other.state) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.url.equals(other.url) && this.parentId.equals(other.parentId) && this.parentIds.equals(other.parentIds) && this.parentType.equals(other.parentType) && this.defaultLocale.equals(other.defaultLocale) && this.translatedContent.equals(other.translatedContent);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.workspaceId, this.title, this.description, this.body, this.authorId, this.state, this.createdAt, this.updatedAt, this.url, this.parentId, this.parentIds, this.parentType, this.defaultLocale, this.translatedContent);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class State {
        public static final State PUBLISHED = new State(Value.PUBLISHED, "published");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PUBLISHED: {
                    return visitor.visitPublished();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "published": {
                    return PUBLISHED;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPublished();

            public T visitDraft();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PUBLISHED,
            DRAFT,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    WorkspaceIdStage,
    TitleStage,
    AuthorIdStage,
    StateStage,
    CreatedAtStage,
    UpdatedAtStage,
    DefaultLocaleStage,
    TranslatedContentStage,
    _FinalStage {
        private String id;
        private String workspaceId;
        private String title;
        private int authorId;
        private State state;
        private int createdAt;
        private int updatedAt;
        private String defaultLocale;
        private ArticleTranslatedContent translatedContent;
        private Optional<String> parentType = Optional.empty();
        private Optional<List<Integer>> parentIds = Optional.empty();
        private Optional<Integer> parentId = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ArticleListItem other) {
            this.type(other.getType());
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.title(other.getTitle());
            this.description(other.getDescription());
            this.body(other.getBody());
            this.authorId(other.getAuthorId());
            this.state(other.getState());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.url(other.getUrl());
            this.parentId(other.getParentId());
            this.parentIds(other.getParentIds());
            this.parentType(other.getParentType());
            this.defaultLocale(other.getDefaultLocale());
            this.translatedContent(other.getTranslatedContent());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public TitleStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public AuthorIdStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="author_id")
        public StateStage authorId(int authorId) {
            this.authorId = authorId;
            return this;
        }

        @Override
        @JsonSetter(value="state")
        public CreatedAtStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public DefaultLocaleStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="default_locale")
        public TranslatedContentStage defaultLocale(@NotNull String defaultLocale) {
            this.defaultLocale = Objects.requireNonNull(defaultLocale, "defaultLocale must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="translated_content")
        public _FinalStage translatedContent(@NotNull ArticleTranslatedContent translatedContent) {
            this.translatedContent = Objects.requireNonNull(translatedContent, "translatedContent must not be null");
            return this;
        }

        @Override
        public _FinalStage parentType(String parentType) {
            this.parentType = Optional.ofNullable(parentType);
            return this;
        }

        @Override
        @JsonSetter(value="parent_type", nulls=Nulls.SKIP)
        public _FinalStage parentType(Optional<String> parentType) {
            this.parentType = parentType;
            return this;
        }

        @Override
        public _FinalStage parentIds(List<Integer> parentIds) {
            this.parentIds = Optional.ofNullable(parentIds);
            return this;
        }

        @Override
        @JsonSetter(value="parent_ids", nulls=Nulls.SKIP)
        public _FinalStage parentIds(Optional<List<Integer>> parentIds) {
            this.parentIds = parentIds;
            return this;
        }

        @Override
        public _FinalStage parentId(Integer parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        @Override
        @JsonSetter(value="parent_id", nulls=Nulls.SKIP)
        public _FinalStage parentId(Optional<Integer> parentId) {
            this.parentId = parentId;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @Override
        public ArticleListItem build() {
            return new ArticleListItem(this.type, this.id, this.workspaceId, this.title, this.description, this.body, this.authorId, this.state, this.createdAt, this.updatedAt, this.url, this.parentId, this.parentIds, this.parentType, this.defaultLocale, this.translatedContent, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ArticleListItem build();

        public _FinalStage type(Optional<String> var1);

        public _FinalStage type(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage parentId(Optional<Integer> var1);

        public _FinalStage parentId(Integer var1);

        public _FinalStage parentIds(Optional<List<Integer>> var1);

        public _FinalStage parentIds(List<Integer> var1);

        public _FinalStage parentType(Optional<String> var1);

        public _FinalStage parentType(String var1);
    }

    public static interface TranslatedContentStage {
        public _FinalStage translatedContent(@NotNull ArticleTranslatedContent var1);
    }

    public static interface DefaultLocaleStage {
        public TranslatedContentStage defaultLocale(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public DefaultLocaleStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface StateStage {
        public CreatedAtStage state(@NotNull State var1);
    }

    public static interface AuthorIdStage {
        public StateStage authorId(int var1);
    }

    public static interface TitleStage {
        public AuthorIdStage title(@NotNull String var1);
    }

    public static interface WorkspaceIdStage {
        public TitleStage workspaceId(@NotNull String var1);
    }

    public static interface IdStage {
        public WorkspaceIdStage id(@NotNull String var1);

        public Builder from(ArticleListItem var1);
    }
}

