/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.companies;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.companies.RawCompaniesClient;
import com.intercom.api.resources.companies.requests.AttachContactToCompanyRequest;
import com.intercom.api.resources.companies.requests.CreateOrUpdateCompanyRequest;
import com.intercom.api.resources.companies.requests.DeleteCompanyRequest;
import com.intercom.api.resources.companies.requests.DetachContactFromCompanyRequest;
import com.intercom.api.resources.companies.requests.FindCompanyRequest;
import com.intercom.api.resources.companies.requests.ListAttachedContactsRequest;
import com.intercom.api.resources.companies.requests.ListCompaniesRequest;
import com.intercom.api.resources.companies.requests.ListSegmentsAttachedToCompanyRequest;
import com.intercom.api.resources.companies.requests.RetrieveCompanyRequest;
import com.intercom.api.resources.companies.requests.ScrollCompaniesRequest;
import com.intercom.api.resources.companies.requests.UpdateCompanyRequest;
import com.intercom.api.resources.companies.types.CompaniesRetrieveResponse;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.types.CompanyAttachedContacts;
import com.intercom.api.types.CompanyAttachedSegments;
import com.intercom.api.types.DeletedCompanyObject;

public class CompaniesClient {
    protected final ClientOptions clientOptions;
    private final RawCompaniesClient rawClient;

    public CompaniesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCompaniesClient(clientOptions);
    }

    public RawCompaniesClient withRawResponse() {
        return this.rawClient;
    }

    public CompaniesRetrieveResponse retrieve() {
        return this.rawClient.retrieve().body();
    }

    public CompaniesRetrieveResponse retrieve(RetrieveCompanyRequest request) {
        return this.rawClient.retrieve(request).body();
    }

    public CompaniesRetrieveResponse retrieve(RetrieveCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieve(request, requestOptions).body();
    }

    public Company createOrUpdate() {
        return this.rawClient.createOrUpdate().body();
    }

    public Company createOrUpdate(CreateOrUpdateCompanyRequest request) {
        return this.rawClient.createOrUpdate(request).body();
    }

    public Company createOrUpdate(CreateOrUpdateCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.createOrUpdate(request, requestOptions).body();
    }

    public Company find(FindCompanyRequest request) {
        return this.rawClient.find(request).body();
    }

    public Company find(FindCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public Company update(UpdateCompanyRequest request) {
        return this.rawClient.update(request).body();
    }

    public Company update(UpdateCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public DeletedCompanyObject delete(DeleteCompanyRequest request) {
        return this.rawClient.delete(request).body();
    }

    public DeletedCompanyObject delete(DeleteCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }

    public CompanyAttachedContacts listAttachedContacts(ListAttachedContactsRequest request) {
        return this.rawClient.listAttachedContacts(request).body();
    }

    public CompanyAttachedContacts listAttachedContacts(ListAttachedContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedContacts(request, requestOptions).body();
    }

    public CompanyAttachedSegments listAttachedSegments(ListSegmentsAttachedToCompanyRequest request) {
        return this.rawClient.listAttachedSegments(request).body();
    }

    public CompanyAttachedSegments listAttachedSegments(ListSegmentsAttachedToCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSegments(request, requestOptions).body();
    }

    public SyncPagingIterable<Company> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Company> list(ListCompaniesRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Company> list(ListCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public SyncPagingIterable<Company> scroll() {
        return this.rawClient.scroll().body();
    }

    public SyncPagingIterable<Company> scroll(ScrollCompaniesRequest request) {
        return this.rawClient.scroll(request).body();
    }

    public SyncPagingIterable<Company> scroll(ScrollCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.scroll(request, requestOptions).body();
    }

    public Company attachContact(AttachContactToCompanyRequest request) {
        return this.rawClient.attachContact(request).body();
    }

    public Company attachContact(AttachContactToCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContact(request, requestOptions).body();
    }

    public Company detachContact(DetachContactFromCompanyRequest request) {
        return this.rawClient.detachContact(request).body();
    }

    public Company detachContact(DetachContactFromCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContact(request, requestOptions).body();
    }
}

