/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataattributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateDataAttributeRequest {
    private final String dataAttributeId;
    private final Optional<Boolean> archived;
    private final Optional<String> description;
    private final Optional<List<OptionsItem>> options;
    private final Optional<Boolean> messengerWritable;
    private final Map<String, Object> additionalProperties;

    private UpdateDataAttributeRequest(String dataAttributeId, Optional<Boolean> archived, Optional<String> description, Optional<List<OptionsItem>> options, Optional<Boolean> messengerWritable, Map<String, Object> additionalProperties) {
        this.dataAttributeId = dataAttributeId;
        this.archived = archived;
        this.description = description;
        this.options = options;
        this.messengerWritable = messengerWritable;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="data_attribute_id")
    public String getDataAttributeId() {
        return this.dataAttributeId;
    }

    @JsonProperty(value="archived")
    public Optional<Boolean> getArchived() {
        return this.archived;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="options")
    public Optional<List<OptionsItem>> getOptions() {
        return this.options;
    }

    @JsonProperty(value="messenger_writable")
    public Optional<Boolean> getMessengerWritable() {
        return this.messengerWritable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateDataAttributeRequest && this.equalTo((UpdateDataAttributeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateDataAttributeRequest other) {
        return this.dataAttributeId.equals(other.dataAttributeId) && this.archived.equals(other.archived) && this.description.equals(other.description) && this.options.equals(other.options) && this.messengerWritable.equals(other.messengerWritable);
    }

    public int hashCode() {
        return Objects.hash(this.dataAttributeId, this.archived, this.description, this.options, this.messengerWritable);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DataAttributeIdStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class OptionsItem {
        private final String value;
        private final Map<String, Object> additionalProperties;

        private OptionsItem(String value, Map<String, Object> additionalProperties) {
            this.value = value;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="value")
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof OptionsItem && this.equalTo((OptionsItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(OptionsItem other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ValueStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements ValueStage,
        _FinalStage {
            private String value;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(OptionsItem other) {
                this.value(other.getValue());
                return this;
            }

            @Override
            @JsonSetter(value="value")
            public _FinalStage value(@NotNull String value) {
                this.value = Objects.requireNonNull(value, "value must not be null");
                return this;
            }

            @Override
            public OptionsItem build() {
                return new OptionsItem(this.value, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public OptionsItem build();
        }

        public static interface ValueStage {
            public _FinalStage value(@NotNull String var1);

            public Builder from(OptionsItem var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DataAttributeIdStage,
    _FinalStage {
        private String dataAttributeId;
        private Optional<Boolean> messengerWritable = Optional.empty();
        private Optional<List<OptionsItem>> options = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Boolean> archived = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateDataAttributeRequest other) {
            this.dataAttributeId(other.getDataAttributeId());
            this.archived(other.getArchived());
            this.description(other.getDescription());
            this.options(other.getOptions());
            this.messengerWritable(other.getMessengerWritable());
            return this;
        }

        @Override
        @JsonSetter(value="data_attribute_id")
        public _FinalStage dataAttributeId(@NotNull String dataAttributeId) {
            this.dataAttributeId = Objects.requireNonNull(dataAttributeId, "dataAttributeId must not be null");
            return this;
        }

        @Override
        public _FinalStage messengerWritable(Boolean messengerWritable) {
            this.messengerWritable = Optional.ofNullable(messengerWritable);
            return this;
        }

        @Override
        @JsonSetter(value="messenger_writable", nulls=Nulls.SKIP)
        public _FinalStage messengerWritable(Optional<Boolean> messengerWritable) {
            this.messengerWritable = messengerWritable;
            return this;
        }

        @Override
        public _FinalStage options(List<OptionsItem> options) {
            this.options = Optional.ofNullable(options);
            return this;
        }

        @Override
        @JsonSetter(value="options", nulls=Nulls.SKIP)
        public _FinalStage options(Optional<List<OptionsItem>> options) {
            this.options = options;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @Override
        @JsonSetter(value="archived", nulls=Nulls.SKIP)
        public _FinalStage archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        @Override
        public UpdateDataAttributeRequest build() {
            return new UpdateDataAttributeRequest(this.dataAttributeId, this.archived, this.description, this.options, this.messengerWritable, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateDataAttributeRequest build();

        public _FinalStage archived(Optional<Boolean> var1);

        public _FinalStage archived(Boolean var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage options(Optional<List<OptionsItem>> var1);

        public _FinalStage options(List<OptionsItem> var1);

        public _FinalStage messengerWritable(Optional<Boolean> var1);

        public _FinalStage messengerWritable(Boolean var1);
    }

    public static interface DataAttributeIdStage {
        public _FinalStage dataAttributeId(@NotNull String var1);

        public Builder from(UpdateDataAttributeRequest var1);
    }
}

