/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.events.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEventsRequest {
    private final Optional<String> userId;
    private final Optional<String> intercomUserId;
    private final Optional<String> email;
    private final String type;
    private final Optional<Boolean> summary;
    private final Optional<Integer> perPage;
    private final Map<String, Object> additionalProperties;

    private ListEventsRequest(Optional<String> userId, Optional<String> intercomUserId, Optional<String> email, String type, Optional<Boolean> summary, Optional<Integer> perPage, Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.intercomUserId = intercomUserId;
        this.email = email;
        this.type = type;
        this.summary = summary;
        this.perPage = perPage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="intercom_user_id")
    public Optional<String> getIntercomUserId() {
        return this.intercomUserId;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="summary")
    public Optional<Boolean> getSummary() {
        return this.summary;
    }

    @JsonProperty(value="per_page")
    public Optional<Integer> getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEventsRequest && this.equalTo((ListEventsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventsRequest other) {
        return this.userId.equals(other.userId) && this.intercomUserId.equals(other.intercomUserId) && this.email.equals(other.email) && this.type.equals(other.type) && this.summary.equals(other.summary) && this.perPage.equals(other.perPage);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.intercomUserId, this.email, this.type, this.summary, this.perPage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    _FinalStage {
        private String type;
        private Optional<Integer> perPage = Optional.empty();
        private Optional<Boolean> summary = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<String> intercomUserId = Optional.empty();
        private Optional<String> userId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListEventsRequest other) {
            this.userId(other.getUserId());
            this.intercomUserId(other.getIntercomUserId());
            this.email(other.getEmail());
            this.type(other.getType());
            this.summary(other.getSummary());
            this.perPage(other.getPerPage());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        @Override
        @JsonSetter(value="per_page", nulls=Nulls.SKIP)
        public _FinalStage perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        @Override
        public _FinalStage summary(Boolean summary) {
            this.summary = Optional.ofNullable(summary);
            return this;
        }

        @Override
        @JsonSetter(value="summary", nulls=Nulls.SKIP)
        public _FinalStage summary(Optional<Boolean> summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @Override
        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @Override
        public _FinalStage intercomUserId(String intercomUserId) {
            this.intercomUserId = Optional.ofNullable(intercomUserId);
            return this;
        }

        @Override
        @JsonSetter(value="intercom_user_id", nulls=Nulls.SKIP)
        public _FinalStage intercomUserId(Optional<String> intercomUserId) {
            this.intercomUserId = intercomUserId;
            return this;
        }

        @Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @Override
        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public ListEventsRequest build() {
            return new ListEventsRequest(this.userId, this.intercomUserId, this.email, this.type, this.summary, this.perPage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListEventsRequest build();

        public _FinalStage userId(Optional<String> var1);

        public _FinalStage userId(String var1);

        public _FinalStage intercomUserId(Optional<String> var1);

        public _FinalStage intercomUserId(String var1);

        public _FinalStage email(Optional<String> var1);

        public _FinalStage email(String var1);

        public _FinalStage summary(Optional<Boolean> var1);

        public _FinalStage summary(Boolean var1);

        public _FinalStage perPage(Optional<Integer> var1);

        public _FinalStage perPage(Integer var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull String var1);

        public Builder from(ListEventsRequest var1);
    }
}

