/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.news.items;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.errors.NotFoundError;
import com.intercom.api.errors.UnauthorizedError;
import com.intercom.api.resources.news.items.requests.DeleteNewsItemRequest;
import com.intercom.api.resources.news.items.requests.FindNewsItemRequest;
import com.intercom.api.resources.news.items.requests.UpdateNewsItemRequest;
import com.intercom.api.resources.news.types.NewsItem;
import com.intercom.api.types.DeletedObject;
import com.intercom.api.types.Error;
import com.intercom.api.types.NewsItemRequest;
import com.intercom.api.types.PaginatedNewsItemResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawItemsClient {
    protected final ClientOptions clientOptions;

    public RawItemsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public IntercomHttpResponse<PaginatedNewsItemResponse> list() {
        return this.list(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<PaginatedNewsItemResponse> list(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<PaginatedNewsItemResponse> intercomHttpResponse = new IntercomHttpResponse<PaginatedNewsItemResponse>((PaginatedNewsItemResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedNewsItemResponse.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 401) throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<NewsItem> create(NewsItemRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<NewsItem> create(NewsItemRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<NewsItem> intercomHttpResponse = new IntercomHttpResponse<NewsItem>((NewsItem)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), NewsItem.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 401) throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<NewsItem> find(FindNewsItemRequest request) {
        return this.find(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<NewsItem> find(FindNewsItemRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").addPathSegment(request.getNewsItemId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<NewsItem> intercomHttpResponse = new IntercomHttpResponse<NewsItem>((NewsItem)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), NewsItem.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<NewsItem> update(UpdateNewsItemRequest request) {
        return this.update(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<NewsItem> update(UpdateNewsItemRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").addPathSegment(request.getNewsItemId()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<NewsItem> intercomHttpResponse = new IntercomHttpResponse<NewsItem>((NewsItem)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), NewsItem.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<DeletedObject> delete(DeleteNewsItemRequest request) {
        return this.delete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<DeletedObject> delete(DeleteNewsItemRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").addPathSegment(request.getNewsItemId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<DeletedObject> intercomHttpResponse = new IntercomHttpResponse<DeletedObject>((DeletedObject)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeletedObject.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}

