/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.news.items.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FindNewsItemRequest {
    private final String newsItemId;
    private final Map<String, Object> additionalProperties;

    private FindNewsItemRequest(String newsItemId, Map<String, Object> additionalProperties) {
        this.newsItemId = newsItemId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="news_item_id")
    public String getNewsItemId() {
        return this.newsItemId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FindNewsItemRequest && this.equalTo((FindNewsItemRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindNewsItemRequest other) {
        return this.newsItemId.equals(other.newsItemId);
    }

    public int hashCode() {
        return Objects.hash(this.newsItemId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NewsItemIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NewsItemIdStage,
    _FinalStage {
        private String newsItemId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FindNewsItemRequest other) {
            this.newsItemId(other.getNewsItemId());
            return this;
        }

        @Override
        @JsonSetter(value="news_item_id")
        public _FinalStage newsItemId(@NotNull String newsItemId) {
            this.newsItemId = Objects.requireNonNull(newsItemId, "newsItemId must not be null");
            return this;
        }

        @Override
        public FindNewsItemRequest build() {
            return new FindNewsItemRequest(this.newsItemId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FindNewsItemRequest build();
    }

    public static interface NewsItemIdStage {
        public _FinalStage newsItemId(@NotNull String var1);

        public Builder from(FindNewsItemRequest var1);
    }
}

