/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateTicketRequest {
    private final String ticketId;
    private final Optional<Map<String, Object>> ticketAttributes;
    private final Optional<State> state;
    private final Optional<Boolean> open;
    private final Optional<Boolean> isShared;
    private final Optional<Integer> snoozedUntil;
    private final Optional<Assignment> assignment;
    private final Map<String, Object> additionalProperties;

    private UpdateTicketRequest(String ticketId, Optional<Map<String, Object>> ticketAttributes, Optional<State> state, Optional<Boolean> open, Optional<Boolean> isShared, Optional<Integer> snoozedUntil, Optional<Assignment> assignment, Map<String, Object> additionalProperties) {
        this.ticketId = ticketId;
        this.ticketAttributes = ticketAttributes;
        this.state = state;
        this.open = open;
        this.isShared = isShared;
        this.snoozedUntil = snoozedUntil;
        this.assignment = assignment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ticket_id")
    public String getTicketId() {
        return this.ticketId;
    }

    @JsonProperty(value="ticket_attributes")
    public Optional<Map<String, Object>> getTicketAttributes() {
        return this.ticketAttributes;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="open")
    public Optional<Boolean> getOpen() {
        return this.open;
    }

    @JsonProperty(value="is_shared")
    public Optional<Boolean> getIsShared() {
        return this.isShared;
    }

    @JsonProperty(value="snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return this.snoozedUntil;
    }

    @JsonProperty(value="assignment")
    public Optional<Assignment> getAssignment() {
        return this.assignment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateTicketRequest && this.equalTo((UpdateTicketRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTicketRequest other) {
        return this.ticketId.equals(other.ticketId) && this.ticketAttributes.equals(other.ticketAttributes) && this.state.equals(other.state) && this.open.equals(other.open) && this.isShared.equals(other.isShared) && this.snoozedUntil.equals(other.snoozedUntil) && this.assignment.equals(other.assignment);
    }

    public int hashCode() {
        return Objects.hash(this.ticketId, this.ticketAttributes, this.state, this.open, this.isShared, this.snoozedUntil, this.assignment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketIdStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Assignment {
        private final Optional<String> adminId;
        private final Optional<String> assigneeId;
        private final Map<String, Object> additionalProperties;

        private Assignment(Optional<String> adminId, Optional<String> assigneeId, Map<String, Object> additionalProperties) {
            this.adminId = adminId;
            this.assigneeId = assigneeId;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="admin_id")
        public Optional<String> getAdminId() {
            return this.adminId;
        }

        @JsonProperty(value="assignee_id")
        public Optional<String> getAssigneeId() {
            return this.assigneeId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Assignment && this.equalTo((Assignment)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Assignment other) {
            return this.adminId.equals(other.adminId) && this.assigneeId.equals(other.assigneeId);
        }

        public int hashCode() {
            return Objects.hash(this.adminId, this.assigneeId);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> adminId = Optional.empty();
            private Optional<String> assigneeId = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Assignment other) {
                this.adminId(other.getAdminId());
                this.assigneeId(other.getAssigneeId());
                return this;
            }

            @JsonSetter(value="admin_id", nulls=Nulls.SKIP)
            public Builder adminId(Optional<String> adminId) {
                this.adminId = adminId;
                return this;
            }

            public Builder adminId(String adminId) {
                this.adminId = Optional.ofNullable(adminId);
                return this;
            }

            @JsonSetter(value="assignee_id", nulls=Nulls.SKIP)
            public Builder assigneeId(Optional<String> assigneeId) {
                this.assigneeId = assigneeId;
                return this;
            }

            public Builder assigneeId(String assigneeId) {
                this.assigneeId = Optional.ofNullable(assigneeId);
                return this;
            }

            public Assignment build() {
                return new Assignment(this.adminId, this.assigneeId, this.additionalProperties);
            }
        }
    }

    public static final class State {
        public static final State IN_PROGRESS = new State(Value.IN_PROGRESS, "in_progress");
        public static final State RESOLVED = new State(Value.RESOLVED, "resolved");
        public static final State WAITING_ON_CUSTOMER = new State(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case IN_PROGRESS: {
                    return visitor.visitInProgress();
                }
                case RESOLVED: {
                    return visitor.visitResolved();
                }
                case WAITING_ON_CUSTOMER: {
                    return visitor.visitWaitingOnCustomer();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "in_progress": {
                    return IN_PROGRESS;
                }
                case "resolved": {
                    return RESOLVED;
                }
                case "waiting_on_customer": {
                    return WAITING_ON_CUSTOMER;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitInProgress();

            public T visitWaitingOnCustomer();

            public T visitResolved();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            IN_PROGRESS,
            WAITING_ON_CUSTOMER,
            RESOLVED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketIdStage,
    _FinalStage {
        private String ticketId;
        private Optional<Assignment> assignment = Optional.empty();
        private Optional<Integer> snoozedUntil = Optional.empty();
        private Optional<Boolean> isShared = Optional.empty();
        private Optional<Boolean> open = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<Map<String, Object>> ticketAttributes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateTicketRequest other) {
            this.ticketId(other.getTicketId());
            this.ticketAttributes(other.getTicketAttributes());
            this.state(other.getState());
            this.open(other.getOpen());
            this.isShared(other.getIsShared());
            this.snoozedUntil(other.getSnoozedUntil());
            this.assignment(other.getAssignment());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_id")
        public _FinalStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @Override
        public _FinalStage assignment(Assignment assignment) {
            this.assignment = Optional.ofNullable(assignment);
            return this;
        }

        @Override
        @JsonSetter(value="assignment", nulls=Nulls.SKIP)
        public _FinalStage assignment(Optional<Assignment> assignment) {
            this.assignment = assignment;
            return this;
        }

        @Override
        public _FinalStage snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        @Override
        @JsonSetter(value="snoozed_until", nulls=Nulls.SKIP)
        public _FinalStage snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        @Override
        public _FinalStage isShared(Boolean isShared) {
            this.isShared = Optional.ofNullable(isShared);
            return this;
        }

        @Override
        @JsonSetter(value="is_shared", nulls=Nulls.SKIP)
        public _FinalStage isShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
            return this;
        }

        @Override
        public _FinalStage open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        @Override
        @JsonSetter(value="open", nulls=Nulls.SKIP)
        public _FinalStage open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        @Override
        public _FinalStage state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @Override
        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public _FinalStage state(Optional<State> state) {
            this.state = state;
            return this;
        }

        @Override
        public _FinalStage ticketAttributes(Map<String, Object> ticketAttributes) {
            this.ticketAttributes = Optional.ofNullable(ticketAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="ticket_attributes", nulls=Nulls.SKIP)
        public _FinalStage ticketAttributes(Optional<Map<String, Object>> ticketAttributes) {
            this.ticketAttributes = ticketAttributes;
            return this;
        }

        @Override
        public UpdateTicketRequest build() {
            return new UpdateTicketRequest(this.ticketId, this.ticketAttributes, this.state, this.open, this.isShared, this.snoozedUntil, this.assignment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateTicketRequest build();

        public _FinalStage ticketAttributes(Optional<Map<String, Object>> var1);

        public _FinalStage ticketAttributes(Map<String, Object> var1);

        public _FinalStage state(Optional<State> var1);

        public _FinalStage state(State var1);

        public _FinalStage open(Optional<Boolean> var1);

        public _FinalStage open(Boolean var1);

        public _FinalStage isShared(Optional<Boolean> var1);

        public _FinalStage isShared(Boolean var1);

        public _FinalStage snoozedUntil(Optional<Integer> var1);

        public _FinalStage snoozedUntil(Integer var1);

        public _FinalStage assignment(Optional<Assignment> var1);

        public _FinalStage assignment(Assignment var1);
    }

    public static interface TicketIdStage {
        public _FinalStage ticketId(@NotNull String var1);

        public Builder from(UpdateTicketRequest var1);
    }
}

