/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.companies;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.companies.RawCompaniesClient;
import com.intercom.api.resources.unstable.companies.requests.AttachContactToACompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.DeleteCompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.DetachContactFromACompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAllCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAttachedContactsRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAttachedSegmentsForCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.RetrieveACompanyByIdRequest;
import com.intercom.api.resources.unstable.companies.requests.RetrieveCompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.ScrollOverAllCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.UpdateCompanyRequest;
import com.intercom.api.resources.unstable.companies.types.Company;
import com.intercom.api.resources.unstable.types.CompanyAttachedContacts;
import com.intercom.api.resources.unstable.types.CompanyAttachedSegments;
import com.intercom.api.resources.unstable.types.CompanyList;
import com.intercom.api.resources.unstable.types.CompanyScroll;
import com.intercom.api.resources.unstable.types.DeletedCompanyObject;
import java.util.Optional;

public class CompaniesClient {
    protected final ClientOptions clientOptions;
    private final RawCompaniesClient rawClient;

    public CompaniesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCompaniesClient(clientOptions);
    }

    public RawCompaniesClient withRawResponse() {
        return this.rawClient;
    }

    public CompanyList retrieveCompany() {
        return this.rawClient.retrieveCompany().body();
    }

    public CompanyList retrieveCompany(RetrieveCompanyRequest request) {
        return this.rawClient.retrieveCompany(request).body();
    }

    public CompanyList retrieveCompany(RetrieveCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveCompany(request, requestOptions).body();
    }

    public Company createOrUpdateCompany(Object request) {
        return this.rawClient.createOrUpdateCompany(request).body();
    }

    public Company createOrUpdateCompany(Object request, RequestOptions requestOptions) {
        return this.rawClient.createOrUpdateCompany(request, requestOptions).body();
    }

    public Company retrieveACompanyById(RetrieveACompanyByIdRequest request) {
        return this.rawClient.retrieveACompanyById(request).body();
    }

    public Company retrieveACompanyById(RetrieveACompanyByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveACompanyById(request, requestOptions).body();
    }

    public Company updateCompany(UpdateCompanyRequest request) {
        return this.rawClient.updateCompany(request).body();
    }

    public Company updateCompany(UpdateCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateCompany(request, requestOptions).body();
    }

    public DeletedCompanyObject deleteCompany(DeleteCompanyRequest request) {
        return this.rawClient.deleteCompany(request).body();
    }

    public DeletedCompanyObject deleteCompany(DeleteCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteCompany(request, requestOptions).body();
    }

    public CompanyAttachedContacts listAttachedContacts(ListAttachedContactsRequest request) {
        return this.rawClient.listAttachedContacts(request).body();
    }

    public CompanyAttachedContacts listAttachedContacts(ListAttachedContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedContacts(request, requestOptions).body();
    }

    public CompanyAttachedSegments listAttachedSegmentsForCompanies(ListAttachedSegmentsForCompaniesRequest request) {
        return this.rawClient.listAttachedSegmentsForCompanies(request).body();
    }

    public CompanyAttachedSegments listAttachedSegmentsForCompanies(ListAttachedSegmentsForCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSegmentsForCompanies(request, requestOptions).body();
    }

    public CompanyList listAllCompanies() {
        return this.rawClient.listAllCompanies().body();
    }

    public CompanyList listAllCompanies(ListAllCompaniesRequest request) {
        return this.rawClient.listAllCompanies(request).body();
    }

    public CompanyList listAllCompanies(ListAllCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAllCompanies(request, requestOptions).body();
    }

    public Optional<CompanyScroll> scrollOverAllCompanies() {
        return this.rawClient.scrollOverAllCompanies().body();
    }

    public Optional<CompanyScroll> scrollOverAllCompanies(ScrollOverAllCompaniesRequest request) {
        return this.rawClient.scrollOverAllCompanies(request).body();
    }

    public Optional<CompanyScroll> scrollOverAllCompanies(ScrollOverAllCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.scrollOverAllCompanies(request, requestOptions).body();
    }

    public Company attachContactToACompany(AttachContactToACompanyRequest request) {
        return this.rawClient.attachContactToACompany(request).body();
    }

    public Company attachContactToACompany(AttachContactToACompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContactToACompany(request, requestOptions).body();
    }

    public Company detachContactFromACompany(DetachContactFromACompanyRequest request) {
        return this.rawClient.detachContactFromACompany(request).body();
    }

    public Company detachContactFromACompany(DetachContactFromACompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContactFromACompany(request, requestOptions).body();
    }
}

