/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.conversations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.aiagent.types.AiAgent;
import com.intercom.api.resources.unstable.types.ConversationContacts;
import com.intercom.api.resources.unstable.types.ConversationFirstContactReply;
import com.intercom.api.resources.unstable.types.ConversationParts;
import com.intercom.api.resources.unstable.types.ConversationRating;
import com.intercom.api.resources.unstable.types.ConversationSource;
import com.intercom.api.resources.unstable.types.ConversationStatistics;
import com.intercom.api.resources.unstable.types.ConversationTeammates;
import com.intercom.api.resources.unstable.types.CustomObjectInstanceList;
import com.intercom.api.resources.unstable.types.Datetime;
import com.intercom.api.resources.unstable.types.LinkedObjectList;
import com.intercom.api.resources.unstable.types.SlaApplied;
import com.intercom.api.resources.unstable.types.Tags;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Conversation {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> title;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<Integer> waitingSince;
    private final Optional<Integer> snoozedUntil;
    private final Optional<Boolean> open;
    private final Optional<State> state;
    private final Optional<Boolean> read;
    private final Optional<Priority> priority;
    private final Optional<Integer> adminAssigneeId;
    private final Optional<String> teamAssigneeId;
    private final Optional<Tags> tags;
    private final Optional<ConversationRating> conversationRating;
    private final Optional<ConversationSource> source;
    private final Optional<ConversationContacts> contacts;
    private final Optional<ConversationTeammates> teammates;
    private final Optional<Map<String, CustomAttributesValue>> customAttributes;
    private final Optional<ConversationFirstContactReply> firstContactReply;
    private final Optional<SlaApplied> slaApplied;
    private final Optional<ConversationStatistics> statistics;
    private final Optional<ConversationParts> conversationParts;
    private final Optional<LinkedObjectList> linkedObjects;
    private final Optional<Boolean> aiAgentParticipated;
    private final Optional<AiAgent> aiAgent;
    private final Map<String, Object> additionalProperties;

    private Conversation(Optional<String> type, Optional<String> id, Optional<String> title, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<Integer> waitingSince, Optional<Integer> snoozedUntil, Optional<Boolean> open, Optional<State> state, Optional<Boolean> read, Optional<Priority> priority, Optional<Integer> adminAssigneeId, Optional<String> teamAssigneeId, Optional<Tags> tags, Optional<ConversationRating> conversationRating, Optional<ConversationSource> source, Optional<ConversationContacts> contacts, Optional<ConversationTeammates> teammates, Optional<Map<String, CustomAttributesValue>> customAttributes, Optional<ConversationFirstContactReply> firstContactReply, Optional<SlaApplied> slaApplied, Optional<ConversationStatistics> statistics, Optional<ConversationParts> conversationParts, Optional<LinkedObjectList> linkedObjects, Optional<Boolean> aiAgentParticipated, Optional<AiAgent> aiAgent, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.title = title;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.waitingSince = waitingSince;
        this.snoozedUntil = snoozedUntil;
        this.open = open;
        this.state = state;
        this.read = read;
        this.priority = priority;
        this.adminAssigneeId = adminAssigneeId;
        this.teamAssigneeId = teamAssigneeId;
        this.tags = tags;
        this.conversationRating = conversationRating;
        this.source = source;
        this.contacts = contacts;
        this.teammates = teammates;
        this.customAttributes = customAttributes;
        this.firstContactReply = firstContactReply;
        this.slaApplied = slaApplied;
        this.statistics = statistics;
        this.conversationParts = conversationParts;
        this.linkedObjects = linkedObjects;
        this.aiAgentParticipated = aiAgentParticipated;
        this.aiAgent = aiAgent;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="waiting_since")
    public Optional<Integer> getWaitingSince() {
        return this.waitingSince;
    }

    @JsonProperty(value="snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return this.snoozedUntil;
    }

    @JsonProperty(value="open")
    public Optional<Boolean> getOpen() {
        return this.open;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="read")
    public Optional<Boolean> getRead() {
        return this.read;
    }

    @JsonProperty(value="priority")
    public Optional<Priority> getPriority() {
        return this.priority;
    }

    @JsonProperty(value="admin_assignee_id")
    public Optional<Integer> getAdminAssigneeId() {
        return this.adminAssigneeId;
    }

    @JsonProperty(value="team_assignee_id")
    public Optional<String> getTeamAssigneeId() {
        return this.teamAssigneeId;
    }

    @JsonProperty(value="tags")
    public Optional<Tags> getTags() {
        return this.tags;
    }

    @JsonProperty(value="conversation_rating")
    public Optional<ConversationRating> getConversationRating() {
        return this.conversationRating;
    }

    @JsonProperty(value="source")
    public Optional<ConversationSource> getSource() {
        return this.source;
    }

    @JsonProperty(value="contacts")
    public Optional<ConversationContacts> getContacts() {
        return this.contacts;
    }

    @JsonProperty(value="teammates")
    public Optional<ConversationTeammates> getTeammates() {
        return this.teammates;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, CustomAttributesValue>> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="first_contact_reply")
    public Optional<ConversationFirstContactReply> getFirstContactReply() {
        return this.firstContactReply;
    }

    @JsonProperty(value="sla_applied")
    public Optional<SlaApplied> getSlaApplied() {
        return this.slaApplied;
    }

    @JsonProperty(value="statistics")
    public Optional<ConversationStatistics> getStatistics() {
        return this.statistics;
    }

    @JsonProperty(value="conversation_parts")
    public Optional<ConversationParts> getConversationParts() {
        return this.conversationParts;
    }

    @JsonProperty(value="linked_objects")
    public Optional<LinkedObjectList> getLinkedObjects() {
        return this.linkedObjects;
    }

    @JsonProperty(value="ai_agent_participated")
    public Optional<Boolean> getAiAgentParticipated() {
        return this.aiAgentParticipated;
    }

    @JsonProperty(value="ai_agent")
    public Optional<AiAgent> getAiAgent() {
        return this.aiAgent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Conversation && this.equalTo((Conversation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Conversation other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.title.equals(other.title) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.waitingSince.equals(other.waitingSince) && this.snoozedUntil.equals(other.snoozedUntil) && this.open.equals(other.open) && this.state.equals(other.state) && this.read.equals(other.read) && this.priority.equals(other.priority) && this.adminAssigneeId.equals(other.adminAssigneeId) && this.teamAssigneeId.equals(other.teamAssigneeId) && this.tags.equals(other.tags) && this.conversationRating.equals(other.conversationRating) && this.source.equals(other.source) && this.contacts.equals(other.contacts) && this.teammates.equals(other.teammates) && this.customAttributes.equals(other.customAttributes) && this.firstContactReply.equals(other.firstContactReply) && this.slaApplied.equals(other.slaApplied) && this.statistics.equals(other.statistics) && this.conversationParts.equals(other.conversationParts) && this.linkedObjects.equals(other.linkedObjects) && this.aiAgentParticipated.equals(other.aiAgentParticipated) && this.aiAgent.equals(other.aiAgent);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.title, this.createdAt, this.updatedAt, this.waitingSince, this.snoozedUntil, this.open, this.state, this.read, this.priority, this.adminAssigneeId, this.teamAssigneeId, this.tags, this.conversationRating, this.source, this.contacts, this.teammates, this.customAttributes, this.firstContactReply, this.slaApplied, this.statistics, this.conversationParts, this.linkedObjects, this.aiAgentParticipated, this.aiAgent);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class CustomAttributesValue {
        private final Object value;
        private final int type;

        private CustomAttributesValue(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((String)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((Integer)this.value);
            }
            if (this.type == 2) {
                return visitor.visit((Datetime)this.value);
            }
            if (this.type == 3) {
                return visitor.visit((CustomObjectInstanceList)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CustomAttributesValue && this.equalTo((CustomAttributesValue)other);
        }

        private boolean equalTo(CustomAttributesValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static CustomAttributesValue of(String value) {
            return new CustomAttributesValue(value, 0);
        }

        public static CustomAttributesValue of(int value) {
            return new CustomAttributesValue(value, 1);
        }

        public static CustomAttributesValue of(Datetime value) {
            return new CustomAttributesValue(value, 2);
        }

        public static CustomAttributesValue of(CustomObjectInstanceList value) {
            return new CustomAttributesValue(value, 3);
        }

        static final class Deserializer
        extends StdDeserializer<CustomAttributesValue> {
            Deserializer() {
                super(CustomAttributesValue.class);
            }

            public CustomAttributesValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return CustomAttributesValue.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (value instanceof Integer) {
                        return CustomAttributesValue.of((Integer)value);
                    }
                    try {
                        return CustomAttributesValue.of((Datetime)ObjectMappers.JSON_MAPPER.convertValue(value, Datetime.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        try {
                            return CustomAttributesValue.of((CustomObjectInstanceList)ObjectMappers.JSON_MAPPER.convertValue(value, CustomObjectInstanceList.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException3) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(String var1);

            public T visit(int var1);

            public T visit(Datetime var1);

            public T visit(CustomObjectInstanceList var1);
        }
    }

    public static final class Priority {
        public static final Priority PRIORITY = new Priority(Value.PRIORITY, "priority");
        public static final Priority NOT_PRIORITY = new Priority(Value.NOT_PRIORITY, "not_priority");
        private final Value value;
        private final String string;

        Priority(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Priority && this.string.equals(((Priority)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PRIORITY: {
                    return visitor.visitPriority();
                }
                case NOT_PRIORITY: {
                    return visitor.visitNotPriority();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Priority valueOf(String value) {
            switch (value) {
                case "priority": {
                    return PRIORITY;
                }
                case "not_priority": {
                    return NOT_PRIORITY;
                }
            }
            return new Priority(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPriority();

            public T visitNotPriority();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PRIORITY,
            NOT_PRIORITY,
            UNKNOWN;

        }
    }

    public static final class State {
        public static final State SNOOZED = new State(Value.SNOOZED, "snoozed");
        public static final State CLOSED = new State(Value.CLOSED, "closed");
        public static final State OPEN = new State(Value.OPEN, "open");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SNOOZED: {
                    return visitor.visitSnoozed();
                }
                case CLOSED: {
                    return visitor.visitClosed();
                }
                case OPEN: {
                    return visitor.visitOpen();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "snoozed": {
                    return SNOOZED;
                }
                case "closed": {
                    return CLOSED;
                }
                case "open": {
                    return OPEN;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitOpen();

            public T visitClosed();

            public T visitSnoozed();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            OPEN,
            CLOSED,
            SNOOZED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<Integer> waitingSince = Optional.empty();
        private Optional<Integer> snoozedUntil = Optional.empty();
        private Optional<Boolean> open = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<Boolean> read = Optional.empty();
        private Optional<Priority> priority = Optional.empty();
        private Optional<Integer> adminAssigneeId = Optional.empty();
        private Optional<String> teamAssigneeId = Optional.empty();
        private Optional<Tags> tags = Optional.empty();
        private Optional<ConversationRating> conversationRating = Optional.empty();
        private Optional<ConversationSource> source = Optional.empty();
        private Optional<ConversationContacts> contacts = Optional.empty();
        private Optional<ConversationTeammates> teammates = Optional.empty();
        private Optional<Map<String, CustomAttributesValue>> customAttributes = Optional.empty();
        private Optional<ConversationFirstContactReply> firstContactReply = Optional.empty();
        private Optional<SlaApplied> slaApplied = Optional.empty();
        private Optional<ConversationStatistics> statistics = Optional.empty();
        private Optional<ConversationParts> conversationParts = Optional.empty();
        private Optional<LinkedObjectList> linkedObjects = Optional.empty();
        private Optional<Boolean> aiAgentParticipated = Optional.empty();
        private Optional<AiAgent> aiAgent = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Conversation other) {
            this.type(other.getType());
            this.id(other.getId());
            this.title(other.getTitle());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.waitingSince(other.getWaitingSince());
            this.snoozedUntil(other.getSnoozedUntil());
            this.open(other.getOpen());
            this.state(other.getState());
            this.read(other.getRead());
            this.priority(other.getPriority());
            this.adminAssigneeId(other.getAdminAssigneeId());
            this.teamAssigneeId(other.getTeamAssigneeId());
            this.tags(other.getTags());
            this.conversationRating(other.getConversationRating());
            this.source(other.getSource());
            this.contacts(other.getContacts());
            this.teammates(other.getTeammates());
            this.customAttributes(other.getCustomAttributes());
            this.firstContactReply(other.getFirstContactReply());
            this.slaApplied(other.getSlaApplied());
            this.statistics(other.getStatistics());
            this.conversationParts(other.getConversationParts());
            this.linkedObjects(other.getLinkedObjects());
            this.aiAgentParticipated(other.getAiAgentParticipated());
            this.aiAgent(other.getAiAgent());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="waiting_since", nulls=Nulls.SKIP)
        public Builder waitingSince(Optional<Integer> waitingSince) {
            this.waitingSince = waitingSince;
            return this;
        }

        public Builder waitingSince(Integer waitingSince) {
            this.waitingSince = Optional.ofNullable(waitingSince);
            return this;
        }

        @JsonSetter(value="snoozed_until", nulls=Nulls.SKIP)
        public Builder snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        public Builder snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        @JsonSetter(value="open", nulls=Nulls.SKIP)
        public Builder open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        public Builder open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="read", nulls=Nulls.SKIP)
        public Builder read(Optional<Boolean> read) {
            this.read = read;
            return this;
        }

        public Builder read(Boolean read) {
            this.read = Optional.ofNullable(read);
            return this;
        }

        @JsonSetter(value="priority", nulls=Nulls.SKIP)
        public Builder priority(Optional<Priority> priority) {
            this.priority = priority;
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = Optional.ofNullable(priority);
            return this;
        }

        @JsonSetter(value="admin_assignee_id", nulls=Nulls.SKIP)
        public Builder adminAssigneeId(Optional<Integer> adminAssigneeId) {
            this.adminAssigneeId = adminAssigneeId;
            return this;
        }

        public Builder adminAssigneeId(Integer adminAssigneeId) {
            this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
            return this;
        }

        @JsonSetter(value="team_assignee_id", nulls=Nulls.SKIP)
        public Builder teamAssigneeId(Optional<String> teamAssigneeId) {
            this.teamAssigneeId = teamAssigneeId;
            return this;
        }

        public Builder teamAssigneeId(String teamAssigneeId) {
            this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(Optional<Tags> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @JsonSetter(value="conversation_rating", nulls=Nulls.SKIP)
        public Builder conversationRating(Optional<ConversationRating> conversationRating) {
            this.conversationRating = conversationRating;
            return this;
        }

        public Builder conversationRating(ConversationRating conversationRating) {
            this.conversationRating = Optional.ofNullable(conversationRating);
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<ConversationSource> source) {
            this.source = source;
            return this;
        }

        public Builder source(ConversationSource source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @JsonSetter(value="contacts", nulls=Nulls.SKIP)
        public Builder contacts(Optional<ConversationContacts> contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder contacts(ConversationContacts contacts) {
            this.contacts = Optional.ofNullable(contacts);
            return this;
        }

        @JsonSetter(value="teammates", nulls=Nulls.SKIP)
        public Builder teammates(Optional<ConversationTeammates> teammates) {
            this.teammates = teammates;
            return this;
        }

        public Builder teammates(ConversationTeammates teammates) {
            this.teammates = Optional.ofNullable(teammates);
            return this;
        }

        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public Builder customAttributes(Optional<Map<String, CustomAttributesValue>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder customAttributes(Map<String, CustomAttributesValue> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @JsonSetter(value="first_contact_reply", nulls=Nulls.SKIP)
        public Builder firstContactReply(Optional<ConversationFirstContactReply> firstContactReply) {
            this.firstContactReply = firstContactReply;
            return this;
        }

        public Builder firstContactReply(ConversationFirstContactReply firstContactReply) {
            this.firstContactReply = Optional.ofNullable(firstContactReply);
            return this;
        }

        @JsonSetter(value="sla_applied", nulls=Nulls.SKIP)
        public Builder slaApplied(Optional<SlaApplied> slaApplied) {
            this.slaApplied = slaApplied;
            return this;
        }

        public Builder slaApplied(SlaApplied slaApplied) {
            this.slaApplied = Optional.ofNullable(slaApplied);
            return this;
        }

        @JsonSetter(value="statistics", nulls=Nulls.SKIP)
        public Builder statistics(Optional<ConversationStatistics> statistics) {
            this.statistics = statistics;
            return this;
        }

        public Builder statistics(ConversationStatistics statistics) {
            this.statistics = Optional.ofNullable(statistics);
            return this;
        }

        @JsonSetter(value="conversation_parts", nulls=Nulls.SKIP)
        public Builder conversationParts(Optional<ConversationParts> conversationParts) {
            this.conversationParts = conversationParts;
            return this;
        }

        public Builder conversationParts(ConversationParts conversationParts) {
            this.conversationParts = Optional.ofNullable(conversationParts);
            return this;
        }

        @JsonSetter(value="linked_objects", nulls=Nulls.SKIP)
        public Builder linkedObjects(Optional<LinkedObjectList> linkedObjects) {
            this.linkedObjects = linkedObjects;
            return this;
        }

        public Builder linkedObjects(LinkedObjectList linkedObjects) {
            this.linkedObjects = Optional.ofNullable(linkedObjects);
            return this;
        }

        @JsonSetter(value="ai_agent_participated", nulls=Nulls.SKIP)
        public Builder aiAgentParticipated(Optional<Boolean> aiAgentParticipated) {
            this.aiAgentParticipated = aiAgentParticipated;
            return this;
        }

        public Builder aiAgentParticipated(Boolean aiAgentParticipated) {
            this.aiAgentParticipated = Optional.ofNullable(aiAgentParticipated);
            return this;
        }

        @JsonSetter(value="ai_agent", nulls=Nulls.SKIP)
        public Builder aiAgent(Optional<AiAgent> aiAgent) {
            this.aiAgent = aiAgent;
            return this;
        }

        public Builder aiAgent(AiAgent aiAgent) {
            this.aiAgent = Optional.ofNullable(aiAgent);
            return this;
        }

        public Conversation build() {
            return new Conversation(this.type, this.id, this.title, this.createdAt, this.updatedAt, this.waitingSince, this.snoozedUntil, this.open, this.state, this.read, this.priority, this.adminAssigneeId, this.teamAssigneeId, this.tags, this.conversationRating, this.source, this.contacts, this.teammates, this.customAttributes, this.firstContactReply, this.slaApplied, this.statistics, this.conversationParts, this.linkedObjects, this.aiAgentParticipated, this.aiAgent, this.additionalProperties);
        }
    }
}

