/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataevents;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.dataevents.AsyncRawDataEventsClient;
import com.intercom.api.resources.unstable.dataevents.requests.CreateDataEventSummariesRequest;
import com.intercom.api.resources.unstable.dataevents.requests.LisDataEventsRequest;
import com.intercom.api.resources.unstable.types.DataEventSummary;
import java.util.concurrent.CompletableFuture;

public class AsyncDataEventsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDataEventsClient rawClient;

    public AsyncDataEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDataEventsClient(clientOptions);
    }

    public AsyncRawDataEventsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DataEventSummary> lisDataEvents(LisDataEventsRequest request) {
        return this.rawClient.lisDataEvents(request).thenApply(response -> (DataEventSummary)response.body());
    }

    public CompletableFuture<DataEventSummary> lisDataEvents(LisDataEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.lisDataEvents(request, requestOptions).thenApply(response -> (DataEventSummary)response.body());
    }

    public CompletableFuture<Void> createDataEvent(Object request) {
        return this.rawClient.createDataEvent(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> createDataEvent(Object request, RequestOptions requestOptions) {
        return this.rawClient.createDataEvent(request, requestOptions).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> dataEventSummaries() {
        return this.rawClient.dataEventSummaries().thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> dataEventSummaries(CreateDataEventSummariesRequest request) {
        return this.rawClient.dataEventSummaries(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> dataEventSummaries(CreateDataEventSummariesRequest request, RequestOptions requestOptions) {
        return this.rawClient.dataEventSummaries(request, requestOptions).thenApply(response -> (Void)response.body());
    }
}

