/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.segments.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListSegmentsRequest {
    private final Optional<Boolean> includeCount;
    private final Map<String, Object> additionalProperties;

    private ListSegmentsRequest(Optional<Boolean> includeCount, Map<String, Object> additionalProperties) {
        this.includeCount = includeCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="include_count")
    public Optional<Boolean> getIncludeCount() {
        return this.includeCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListSegmentsRequest && this.equalTo((ListSegmentsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListSegmentsRequest other) {
        return this.includeCount.equals(other.includeCount);
    }

    public int hashCode() {
        return Objects.hash(this.includeCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> includeCount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListSegmentsRequest other) {
            this.includeCount(other.getIncludeCount());
            return this;
        }

        @JsonSetter(value="include_count", nulls=Nulls.SKIP)
        public Builder includeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public Builder includeCount(Boolean includeCount) {
            this.includeCount = Optional.ofNullable(includeCount);
            return this;
        }

        public ListSegmentsRequest build() {
            return new ListSegmentsRequest(this.includeCount, this.additionalProperties);
        }
    }
}

