/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationResponseTime {
    private final Optional<Integer> teamId;
    private final Optional<String> teamName;
    private final Optional<Integer> responseTime;
    private final Map<String, Object> additionalProperties;

    private ConversationResponseTime(Optional<Integer> teamId, Optional<String> teamName, Optional<Integer> responseTime, Map<String, Object> additionalProperties) {
        this.teamId = teamId;
        this.teamName = teamName;
        this.responseTime = responseTime;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="team_id")
    public Optional<Integer> getTeamId() {
        return this.teamId;
    }

    @JsonProperty(value="team_name")
    public Optional<String> getTeamName() {
        return this.teamName;
    }

    @JsonProperty(value="response_time")
    public Optional<Integer> getResponseTime() {
        return this.responseTime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationResponseTime && this.equalTo((ConversationResponseTime)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationResponseTime other) {
        return this.teamId.equals(other.teamId) && this.teamName.equals(other.teamName) && this.responseTime.equals(other.responseTime);
    }

    public int hashCode() {
        return Objects.hash(this.teamId, this.teamName, this.responseTime);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> teamId = Optional.empty();
        private Optional<String> teamName = Optional.empty();
        private Optional<Integer> responseTime = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationResponseTime other) {
            this.teamId(other.getTeamId());
            this.teamName(other.getTeamName());
            this.responseTime(other.getResponseTime());
            return this;
        }

        @JsonSetter(value="team_id", nulls=Nulls.SKIP)
        public Builder teamId(Optional<Integer> teamId) {
            this.teamId = teamId;
            return this;
        }

        public Builder teamId(Integer teamId) {
            this.teamId = Optional.ofNullable(teamId);
            return this;
        }

        @JsonSetter(value="team_name", nulls=Nulls.SKIP)
        public Builder teamName(Optional<String> teamName) {
            this.teamName = teamName;
            return this;
        }

        public Builder teamName(String teamName) {
            this.teamName = Optional.ofNullable(teamName);
            return this;
        }

        @JsonSetter(value="response_time", nulls=Nulls.SKIP)
        public Builder responseTime(Optional<Integer> responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public Builder responseTime(Integer responseTime) {
            this.responseTime = Optional.ofNullable(responseTime);
            return this;
        }

        public ConversationResponseTime build() {
            return new ConversationResponseTime(this.teamId, this.teamName, this.responseTime, this.additionalProperties);
        }
    }
}

