/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OperatorWorkflowEvent {
    private final Optional<Workflow> workflow;
    private final Optional<Event> event;
    private final Map<String, Object> additionalProperties;

    private OperatorWorkflowEvent(Optional<Workflow> workflow, Optional<Event> event, Map<String, Object> additionalProperties) {
        this.workflow = workflow;
        this.event = event;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="workflow")
    public Optional<Workflow> getWorkflow() {
        return this.workflow;
    }

    @JsonProperty(value="event")
    public Optional<Event> getEvent() {
        return this.event;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OperatorWorkflowEvent && this.equalTo((OperatorWorkflowEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OperatorWorkflowEvent other) {
        return this.workflow.equals(other.workflow) && this.event.equals(other.event);
    }

    public int hashCode() {
        return Objects.hash(this.workflow, this.event);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Workflow {
        private final Optional<String> name;
        private final Map<String, Object> additionalProperties;

        private Workflow(Optional<String> name, Map<String, Object> additionalProperties) {
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Workflow && this.equalTo((Workflow)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Workflow other) {
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Workflow other) {
                this.name(other.getName());
                return this;
            }

            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Workflow build() {
                return new Workflow(this.name, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Event {
        private final Optional<String> type;
        private final Optional<String> result;
        private final Map<String, Object> additionalProperties;

        private Event(Optional<String> type, Optional<String> result, Map<String, Object> additionalProperties) {
            this.type = type;
            this.result = result;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="result")
        public Optional<String> getResult() {
            return this.result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Event && this.equalTo((Event)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Event other) {
            return this.type.equals(other.type) && this.result.equals(other.result);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.result);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<String> result = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Event other) {
                this.type(other.getType());
                this.result(other.getResult());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="result", nulls=Nulls.SKIP)
            public Builder result(Optional<String> result) {
                this.result = result;
                return this;
            }

            public Builder result(String result) {
                this.result = Optional.ofNullable(result);
                return this;
            }

            public Event build() {
                return new Event(this.type, this.result, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Workflow> workflow = Optional.empty();
        private Optional<Event> event = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OperatorWorkflowEvent other) {
            this.workflow(other.getWorkflow());
            this.event(other.getEvent());
            return this;
        }

        @JsonSetter(value="workflow", nulls=Nulls.SKIP)
        public Builder workflow(Optional<Workflow> workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = Optional.ofNullable(workflow);
            return this;
        }

        @JsonSetter(value="event", nulls=Nulls.SKIP)
        public Builder event(Optional<Event> event) {
            this.event = event;
            return this;
        }

        public Builder event(Event event) {
            this.event = Optional.ofNullable(event);
            return this;
        }

        public OperatorWorkflowEvent build() {
            return new OperatorWorkflowEvent(this.workflow, this.event, this.additionalProperties);
        }
    }
}

