/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intercom.api.types.ButtonComponent;
import com.intercom.api.types.CheckboxComponent;
import com.intercom.api.types.DataTableComponent;
import com.intercom.api.types.DividerComponent;
import com.intercom.api.types.DropdownComponent;
import com.intercom.api.types.ImageComponent;
import com.intercom.api.types.InputComponent;
import com.intercom.api.types.ListComponent;
import com.intercom.api.types.SingleSelectComponent;
import com.intercom.api.types.SpacerComponent;
import com.intercom.api.types.TextAreaComponent;
import com.intercom.api.types.TextComponent;
import java.util.Objects;
import java.util.Optional;

public final class Component {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private Component(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static Component button(ButtonComponent value) {
        return new Component(new ButtonValue(value));
    }

    public static Component checkbox(CheckboxComponent value) {
        return new Component(new CheckboxValue(value));
    }

    public static Component dropdown(DropdownComponent value) {
        return new Component(new DropdownValue(value));
    }

    public static Component input(InputComponent value) {
        return new Component(new InputValue(value));
    }

    public static Component list(ListComponent value) {
        return new Component(new ListValue(value));
    }

    public static Component singleSelect(SingleSelectComponent value) {
        return new Component(new SingleSelectValue(value));
    }

    public static Component textarea(TextAreaComponent value) {
        return new Component(new TextareaValue(value));
    }

    public static Component dataTable(DataTableComponent value) {
        return new Component(new DataTableValue(value));
    }

    public static Component divider(DividerComponent value) {
        return new Component(new DividerValue(value));
    }

    public static Component image(ImageComponent value) {
        return new Component(new ImageValue(value));
    }

    public static Component spacer(SpacerComponent value) {
        return new Component(new SpacerValue(value));
    }

    public static Component text(TextComponent value) {
        return new Component(new TextValue(value));
    }

    public boolean isButton() {
        return this.value instanceof ButtonValue;
    }

    public boolean isCheckbox() {
        return this.value instanceof CheckboxValue;
    }

    public boolean isDropdown() {
        return this.value instanceof DropdownValue;
    }

    public boolean isInput() {
        return this.value instanceof InputValue;
    }

    public boolean isList() {
        return this.value instanceof ListValue;
    }

    public boolean isSingleSelect() {
        return this.value instanceof SingleSelectValue;
    }

    public boolean isTextarea() {
        return this.value instanceof TextareaValue;
    }

    public boolean isDataTable() {
        return this.value instanceof DataTableValue;
    }

    public boolean isDivider() {
        return this.value instanceof DividerValue;
    }

    public boolean isImage() {
        return this.value instanceof ImageValue;
    }

    public boolean isSpacer() {
        return this.value instanceof SpacerValue;
    }

    public boolean isText() {
        return this.value instanceof TextValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<ButtonComponent> getButton() {
        if (this.isButton()) {
            return Optional.of(((ButtonValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CheckboxComponent> getCheckbox() {
        if (this.isCheckbox()) {
            return Optional.of(((CheckboxValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<DropdownComponent> getDropdown() {
        if (this.isDropdown()) {
            return Optional.of(((DropdownValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<InputComponent> getInput() {
        if (this.isInput()) {
            return Optional.of(((InputValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ListComponent> getList() {
        if (this.isList()) {
            return Optional.of(((ListValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<SingleSelectComponent> getSingleSelect() {
        if (this.isSingleSelect()) {
            return Optional.of(((SingleSelectValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<TextAreaComponent> getTextarea() {
        if (this.isTextarea()) {
            return Optional.of(((TextareaValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<DataTableComponent> getDataTable() {
        if (this.isDataTable()) {
            return Optional.of(((DataTableValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<DividerComponent> getDivider() {
        if (this.isDivider()) {
            return Optional.of(((DividerValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ImageComponent> getImage() {
        if (this.isImage()) {
            return Optional.of(((ImageValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<SpacerComponent> getSpacer() {
        if (this.isSpacer()) {
            return Optional.of(((SpacerValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<TextComponent> getText() {
        if (this.isText()) {
            return Optional.of(((TextValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "Component{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="text")
    @JsonIgnoreProperties(value={"type"})
    private static final class TextValue
    implements Value {
        @JsonUnwrapped
        private TextComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TextValue() {
        }

        private TextValue(TextComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitText(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TextValue && this.equalTo((TextValue)other);
        }

        private boolean equalTo(TextValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="spacer")
    @JsonIgnoreProperties(value={"type"})
    private static final class SpacerValue
    implements Value {
        @JsonUnwrapped
        private SpacerComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SpacerValue() {
        }

        private SpacerValue(SpacerComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSpacer(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SpacerValue && this.equalTo((SpacerValue)other);
        }

        private boolean equalTo(SpacerValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="image")
    @JsonIgnoreProperties(value={"type"})
    private static final class ImageValue
    implements Value {
        @JsonUnwrapped
        private ImageComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ImageValue() {
        }

        private ImageValue(ImageComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitImage(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ImageValue && this.equalTo((ImageValue)other);
        }

        private boolean equalTo(ImageValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="divider")
    @JsonIgnoreProperties(value={"type"})
    private static final class DividerValue
    implements Value {
        @JsonUnwrapped
        private DividerComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DividerValue() {
        }

        private DividerValue(DividerComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDivider(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof DividerValue && this.equalTo((DividerValue)other);
        }

        private boolean equalTo(DividerValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="data-table")
    @JsonIgnoreProperties(value={"type"})
    private static final class DataTableValue
    implements Value {
        @JsonUnwrapped
        private DataTableComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DataTableValue() {
        }

        private DataTableValue(DataTableComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDataTable(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof DataTableValue && this.equalTo((DataTableValue)other);
        }

        private boolean equalTo(DataTableValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="textarea")
    @JsonIgnoreProperties(value={"type"})
    private static final class TextareaValue
    implements Value {
        @JsonUnwrapped
        private TextAreaComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TextareaValue() {
        }

        private TextareaValue(TextAreaComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTextarea(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TextareaValue && this.equalTo((TextareaValue)other);
        }

        private boolean equalTo(TextareaValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="single-select")
    @JsonIgnoreProperties(value={"type"})
    private static final class SingleSelectValue
    implements Value {
        @JsonUnwrapped
        private SingleSelectComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SingleSelectValue() {
        }

        private SingleSelectValue(SingleSelectComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSingleSelect(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SingleSelectValue && this.equalTo((SingleSelectValue)other);
        }

        private boolean equalTo(SingleSelectValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="list")
    @JsonIgnoreProperties(value={"type"})
    private static final class ListValue
    implements Value {
        @JsonUnwrapped
        private ListComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ListValue() {
        }

        private ListValue(ListComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitList(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ListValue && this.equalTo((ListValue)other);
        }

        private boolean equalTo(ListValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="input")
    @JsonIgnoreProperties(value={"type"})
    private static final class InputValue
    implements Value {
        @JsonUnwrapped
        private InputComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private InputValue() {
        }

        private InputValue(InputComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitInput(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof InputValue && this.equalTo((InputValue)other);
        }

        private boolean equalTo(InputValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="dropdown")
    @JsonIgnoreProperties(value={"type"})
    private static final class DropdownValue
    implements Value {
        @JsonUnwrapped
        private DropdownComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DropdownValue() {
        }

        private DropdownValue(DropdownComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDropdown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof DropdownValue && this.equalTo((DropdownValue)other);
        }

        private boolean equalTo(DropdownValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="checkbox")
    @JsonIgnoreProperties(value={"type"})
    private static final class CheckboxValue
    implements Value {
        @JsonUnwrapped
        private CheckboxComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CheckboxValue() {
        }

        private CheckboxValue(CheckboxComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCheckbox(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CheckboxValue && this.equalTo((CheckboxValue)other);
        }

        private boolean equalTo(CheckboxValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="button")
    @JsonIgnoreProperties(value={"type"})
    private static final class ButtonValue
    implements Value {
        @JsonUnwrapped
        private ButtonComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ButtonValue() {
        }

        private ButtonValue(ButtonComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitButton(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ButtonValue && this.equalTo((ButtonValue)other);
        }

        private boolean equalTo(ButtonValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Component{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ButtonValue.class), @JsonSubTypes.Type(value=CheckboxValue.class), @JsonSubTypes.Type(value=DropdownValue.class), @JsonSubTypes.Type(value=InputValue.class), @JsonSubTypes.Type(value=ListValue.class), @JsonSubTypes.Type(value=SingleSelectValue.class), @JsonSubTypes.Type(value=TextareaValue.class), @JsonSubTypes.Type(value=DataTableValue.class), @JsonSubTypes.Type(value=DividerValue.class), @JsonSubTypes.Type(value=ImageValue.class), @JsonSubTypes.Type(value=SpacerValue.class), @JsonSubTypes.Type(value=TextValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitButton(ButtonComponent var1);

        public T visitCheckbox(CheckboxComponent var1);

        public T visitDropdown(DropdownComponent var1);

        public T visitInput(InputComponent var1);

        public T visitList(ListComponent var1);

        public T visitSingleSelect(SingleSelectComponent var1);

        public T visitTextarea(TextAreaComponent var1);

        public T visitDataTable(DataTableComponent var1);

        public T visitDivider(DividerComponent var1);

        public T visitImage(ImageComponent var1);

        public T visitSpacer(SpacerComponent var1);

        public T visitText(TextComponent var1);

        public T _visitUnknown(Object var1);
    }
}

