/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CanvasObject;
import com.intercom.api.types.ResultsResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using=Deserializer.class)
public final class ConfigureResponse {
    private final Object value;
    private final int type;

    private ConfigureResponse(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((ResultsResponse)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((Canvas)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConfigureResponse && this.equalTo((ConfigureResponse)other);
    }

    private boolean equalTo(ConfigureResponse other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static ConfigureResponse of(ResultsResponse value) {
        return new ConfigureResponse(value, 0);
    }

    public static ConfigureResponse of(Canvas value) {
        return new ConfigureResponse(value, 1);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Canvas {
        private final CanvasObject canvas;
        private final Map<String, Object> additionalProperties;

        private Canvas(CanvasObject canvas, Map<String, Object> additionalProperties) {
            this.canvas = canvas;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="canvas")
        public CanvasObject getCanvas() {
            return this.canvas;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Canvas && this.equalTo((Canvas)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Canvas other) {
            return this.canvas.equals(other.canvas);
        }

        public int hashCode() {
            return Objects.hash(this.canvas);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static CanvasStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements CanvasStage,
        _FinalStage {
            private CanvasObject canvas;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(Canvas other) {
                this.canvas(other.getCanvas());
                return this;
            }

            @Override
            @JsonSetter(value="canvas")
            public _FinalStage canvas(@NotNull CanvasObject canvas) {
                this.canvas = Objects.requireNonNull(canvas, "canvas must not be null");
                return this;
            }

            @Override
            public Canvas build() {
                return new Canvas(this.canvas, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public Canvas build();
        }

        public static interface CanvasStage {
            public _FinalStage canvas(@NotNull CanvasObject var1);

            public Builder from(Canvas var1);
        }
    }

    static final class Deserializer
    extends StdDeserializer<ConfigureResponse> {
        Deserializer() {
            super(ConfigureResponse.class);
        }

        public ConfigureResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return ConfigureResponse.of((ResultsResponse)ObjectMappers.JSON_MAPPER.convertValue(value, ResultsResponse.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return ConfigureResponse.of((Canvas)ObjectMappers.JSON_MAPPER.convertValue(value, Canvas.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(ResultsResponse var1);

        public T visit(Canvas var1);
    }
}

