/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactCompany {
    private final String id;
    private final String url;
    private final Map<String, Object> additionalProperties;

    private ContactCompany(String id, String url, Map<String, Object> additionalProperties) {
        this.id = id;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "company";
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactCompany && this.equalTo((ContactCompany)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactCompany other) {
        return this.id.equals(other.id) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    UrlStage,
    _FinalStage {
        private String id;
        private String url;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContactCompany other) {
            this.id(other.getId());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public UrlStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public ContactCompany build() {
            return new ContactCompany(this.id, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContactCompany build();
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);
    }

    public static interface IdStage {
        public UrlStage id(@NotNull String var1);

        public Builder from(ContactCompany var1);
    }
}

