/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ConversationPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationParts {
    private final List<ConversationPart> conversationParts;
    private final int totalCount;
    private final Map<String, Object> additionalProperties;

    private ConversationParts(List<ConversationPart> conversationParts, int totalCount, Map<String, Object> additionalProperties) {
        this.conversationParts = conversationParts;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "conversation_part.list";
    }

    @JsonProperty(value="conversation_parts")
    public List<ConversationPart> getConversationParts() {
        return this.conversationParts;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationParts && this.equalTo((ConversationParts)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationParts other) {
        return this.conversationParts.equals(other.conversationParts) && this.totalCount == other.totalCount;
    }

    public int hashCode() {
        return Objects.hash(this.conversationParts, this.totalCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private List<ConversationPart> conversationParts = new ArrayList<ConversationPart>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConversationParts other) {
            this.conversationParts(other.getConversationParts());
            this.totalCount(other.getTotalCount());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllConversationParts(List<ConversationPart> conversationParts) {
            this.conversationParts.addAll(conversationParts);
            return this;
        }

        @Override
        public _FinalStage addConversationParts(ConversationPart conversationParts) {
            this.conversationParts.add(conversationParts);
            return this;
        }

        @Override
        @JsonSetter(value="conversation_parts", nulls=Nulls.SKIP)
        public _FinalStage conversationParts(List<ConversationPart> conversationParts) {
            this.conversationParts.clear();
            this.conversationParts.addAll(conversationParts);
            return this;
        }

        @Override
        public ConversationParts build() {
            return new ConversationParts(this.conversationParts, this.totalCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConversationParts build();

        public _FinalStage conversationParts(List<ConversationPart> var1);

        public _FinalStage addConversationParts(ConversationPart var1);

        public _FinalStage addAllConversationParts(List<ConversationPart> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(ConversationParts var1);
    }
}

